/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.utils;

import com.freescale.s32ds.cross.core.preferences.PreferenceStoreSupport;
import com.freescale.s32ds.cross.core.utils.EntryDialog;
import com.freescale.s32ds.cross.core.utils.LibraryDialog;
import com.freescale.s32ds.cross.core.utils.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class SelectAddListEditor
extends FieldEditor {
    private final ArrayList<Tuple> npwtuples = new ArrayList();
    private final ArrayList<Tuple> selection = new ArrayList();
    private List list;
    private Composite buttonBox;
    private Button addButton;
    private Button selectButton;
    private SelectionListener selectionListener;

    public SelectAddListEditor() {
        this.npwtuples.addAll(Arrays.asList(PreferenceStoreSupport.getTuples()));
    }

    public Tuple[] getData() {
        return this.selection.toArray(new Tuple[this.selection.size()]);
    }

    public SelectAddListEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    private void addPressed() {
        this.setPresentsDefaultValue(false);
        String input = this.getEntryName("add a new entry");
        if (input != null) {
            int index = this.list.getSelectionIndex();
            if (index >= 0) {
                this.list.add(input, index + 1);
            } else {
                this.list.add(input, 0);
            }
            this.selectionChanged();
            this.getNewInputObject(input);
        }
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.list.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    private void createButtons(Composite box) {
        this.selectButton = this.createPushButton(box, "select");
        this.addButton = this.createPushButton(box, "add");
    }

    private Button createPushButton(Composite parent, String key) {
        Button button = new Button(parent, 8);
        button.setText(JFaceResources.getString((String)key));
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == SelectAddListEditor.this.addButton) {
                    SelectAddListEditor.this.addPressed();
                } else if (widget == SelectAddListEditor.this.selectButton) {
                    SelectAddListEditor.this.selectPressed();
                } else if (widget == SelectAddListEditor.this.list) {
                    SelectAddListEditor.this.selectionChanged();
                }
            }
        };
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        this.list = this.getListControl(parent);
        gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
        this.list.setLayoutData((Object)gd);
        this.buttonBox = this.getButtonBoxControl(parent);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.buttonBox.setLayoutData((Object)gd);
    }

    private void selectPressed() {
        this.setPresentsDefaultValue(false);
        this.selectItem(this.list.getSelectionIndex());
    }

    public Composite getButtonBoxControl(Composite parent) {
        if (this.buttonBox == null) {
            this.buttonBox = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.buttonBox.setLayout((Layout)layout);
            this.createButtons(this.buttonBox);
            this.buttonBox.addDisposeListener(event -> {
                this.addButton = null;
                this.selectButton = null;
                this.buttonBox = null;
            });
        } else {
            this.checkParent((Control)this.buttonBox, parent);
        }
        this.selectionChanged();
        return this.buttonBox;
    }

    public List getListControl(Composite parent) {
        if (this.list == null) {
            this.list = new List(parent, 2820);
            this.list.setFont(parent.getFont());
            this.list.addSelectionListener(this.getSelectionListener());
            this.list.addDisposeListener(event -> {
                List list = this.list = null;
            });
        } else {
            this.checkParent((Control)this.list, parent);
        }
        return this.list;
    }

    protected void getNewInputObject(String lab) {
        Tuple filter = null;
        LibraryDialog dialog = new LibraryDialog(this.getShell());
        dialog.create();
        if (dialog.open() == 0 && (filter = dialog.getInput(lab)) != null) {
            this.npwtuples.add(filter);
            this.selection.add(filter);
        }
    }

    protected void selectItem(int index) {
        this.selection.add(this.npwtuples.get(index));
        this.selectionChanged();
    }

    protected String getEntryName(String lab) {
        EntryDialog dialog = new EntryDialog(this.getShell(), lab);
        dialog.create();
        if (dialog.open() == 0) {
            System.out.println(dialog.getFilter());
            return dialog.getFilter();
        }
        return null;
    }

    public int getNumberOfControls() {
        return 2;
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    protected Shell getShell() {
        return this.addButton == null ? null : this.addButton.getShell();
    }

    protected void selectionChanged() {
        int index = this.list.getSelectionIndex();
        this.selectButton.setEnabled(index >= 0);
    }

    public void setFocus() {
        if (this.list != null) {
            this.list.setFocus();
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getListControl(parent).setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.selectButton.setEnabled(enabled);
    }

    protected Button getAddButton() {
        return this.addButton;
    }

    protected Button getSelectButton() {
        return this.selectButton;
    }

    protected List getList() {
        return this.list;
    }

    public void doLoad() {
        PreferenceStoreSupport.doLoad(this.getList());
    }

    public void doLoadDefault() {
        PreferenceStoreSupport.doLoadDefault(this.getList());
    }

    public void doStore() {
    }
}

