/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.data;

import com.freescale.s32ds.cross.core.Activator;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.registry.ModelRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;

public final class DataSet
extends ConfigurationData {
    private final List<ConfigurationData> dataSet = new ArrayList<ConfigurationData>();
    private final String elementTag;

    DataSet(IConfigurationElement ce, ConfigurationData parent, ModelRegistry registry) {
        super(ce, parent, registry);
        this.elementTag = this.initValues(ce, registry);
    }

    DataSet(DataSet fromDataSet, List<ConfigurationData> newElements) {
        super(fromDataSet.getTag(), fromDataSet.getParent(), fromDataSet.getRegistry());
        this.dataSet.addAll(newElements);
        this.elementTag = fromDataSet.getElementTag();
    }

    public String getElementTag() {
        return this.elementTag;
    }

    @Override
    public List<ConfigurationData> getElements() {
        return Collections.unmodifiableList(this.dataSet);
    }

    @Override
    public List<ConfigurationData> getElements(String tag) {
        if (this.getTag().equals(tag)) {
            return Arrays.asList(this);
        }
        if (this.getTag().equals(this.elementTag)) {
            return Collections.unmodifiableList(this.dataSet);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<ConfigurationData> getElements(String tag, boolean considerSetElementTag) {
        return this.getElements(tag);
    }

    @Override
    public List<ConfigurationData> getElements(String tag, boolean parentSearch, boolean childrenSearch) {
        return this.getElements(tag);
    }

    public String toString() {
        return "{" + this.getBaseInfo() + ": " + this.dataSet + "}";
    }

    @Override
    public ConfigurationData getElement(String tag) {
        if (this.getTag().equals(tag)) {
            return this;
        }
        if (this.getElementTag().equals(tag)) {
            return this.dataSet.size() > 0 ? this.dataSet.get(0) : null;
        }
        return null;
    }

    @Override
    public String getValue(String tag) {
        ConfigurationData d = this.getElement(tag);
        return d != null ? d.getId() : null;
    }

    public Set<String> getElementIds() {
        List<ConfigurationData> elements = this.getElements();
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (ConfigurationData element : elements) {
            result.add(element.getId());
        }
        return result;
    }

    public List<Object> getValues() {
        List<ConfigurationData> elements = this.getElements();
        ArrayList<Object> values = new ArrayList<Object>();
        for (ConfigurationData element : elements) {
            values.add(element.getValue(element.getTag()));
        }
        return values;
    }

    public ConfigurationData getDefaultElement() {
        return this.getElement(this.elementTag);
    }

    public String getDefaultValue() {
        return this.getValue(this.elementTag);
    }

    @Override
    public String getDisplayValue(String tag) {
        ConfigurationData d = this.getElement(tag);
        return d != null ? d.getName() : null;
    }

    private String initValues(IConfigurationElement ce, ModelRegistry registry) {
        IConfigurationElement[] childrenCE;
        LinkedHashSet<ConfigurationData> dSet = new LinkedHashSet<ConfigurationData>();
        String tag = this.getTag();
        String elementsTag = tag.substring(0, tag.length() - 3);
        IConfigurationElement[] iConfigurationElementArray = childrenCE = ce.getChildren();
        int n = childrenCE.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement childCE = iConfigurationElementArray[n2];
            String childTagName = childCE.getName();
            if (childTagName.endsWith("Ref")) {
                String[] childAttributeNames = childCE.getAttributeNames();
                String childTag = null;
                String childValueId = null;
                String[] stringArray = childAttributeNames;
                int n3 = childAttributeNames.length;
                int n4 = 0;
                while (n4 < n3) {
                    String an = stringArray[n4];
                    if (an.endsWith("Id") && an.length() > 2) {
                        childTag = an.substring(0, an.length() - 2);
                        childValueId = childCE.getAttribute(an);
                        break;
                    }
                    ++n4;
                }
                if (childTag != null) {
                    ConfigurationData data = registry.getData(childTag, childValueId);
                    if (data == null) {
                        Activator.logWarning("Child data not defined : " + childValueId + ", tag: " + childTag + ", set: " + this.getId() + "!");
                    } else {
                        if (!elementsTag.equals(data.getTag())) {
                            Activator.logWarning("Incorrect DataSet definition " + data.getTag() + " " + this.getId());
                        }
                        dSet.add(data);
                    }
                }
            }
            ++n2;
        }
        this.dataSet.addAll(dSet);
        return elementsTag;
    }
}

