/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.data;

import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.CoreData;
import com.freescale.s32ds.cross.core.model.data.CoreNatureMasterData;
import com.freescale.s32ds.cross.core.model.data.TemplateData;
import com.freescale.s32ds.cross.core.model.registry.ModelRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;

public class CoreTypeData
extends CoreNatureMasterData {
    private final List<CoreData> cores = new ArrayList<CoreData>();

    public CoreTypeData(IConfigurationElement ce, ConfigurationData parent, ModelRegistry registry) {
        super(ce, parent, registry);
    }

    @Override
    public boolean isAutoStart() {
        return false;
    }

    public List<CoreData> getCores() {
        if (this.cores.isEmpty()) {
            List<CoreData> pcs = this.getProcessor().getCores();
            for (CoreData c : pcs) {
                if (!this.equals(c.getCoreType())) continue;
                this.cores.add(c);
            }
        }
        return Collections.unmodifiableList(this.cores);
    }

    @Override
    public CoreTypeData getCoreType() {
        return this;
    }

    @Override
    protected void addTemplate(TemplateData template) {
        super.addTemplate(template);
        List<CoreData> cores = this.getCores();
        for (CoreData c : cores) {
            c.addTemplate(template);
        }
    }
}

