/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.context;

import com.freescale.s32ds.cross.core.Activator;
import com.freescale.s32ds.cross.core.model.ParameterType;
import com.freescale.s32ds.cross.core.model.context.AbstractContext;
import com.freescale.s32ds.cross.core.model.data.DataSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ContextChange {
    private final Map<String, Object> valueMap = new LinkedHashMap<String, Object>();
    private final Map<String, DataSet> dataSetMap = new LinkedHashMap<String, DataSet>();
    private final Map<String, String> setElementTagMap = new HashMap<String, String>();
    private final AbstractContext context;
    private final String causeTag;

    public ContextChange(AbstractContext context, String causeTag) {
        this.context = context;
        this.causeTag = causeTag;
    }

    public AbstractContext getContext() {
        return this.context;
    }

    public String getCauseTag() {
        return this.causeTag;
    }

    public Map<String, String> getSetElementTagMap() {
        return this.setElementTagMap;
    }

    public void addDataSet(DataSet dataSet) {
        if (dataSet == null) {
            Activator.logWarning("Trying to add null DataSet in ContextChange " + this.getCauseTag());
            return;
        }
        if (dataSet.getDefaultValue() == null) {
            Activator.logWarning("Trying to add DataSet without elements in ContextChange " + this.getCauseTag());
            return;
        }
        this.dataSetMap.put(dataSet.getTag(), dataSet);
        this.setElementTagMap.put(dataSet.getTag(), dataSet.getElementTag());
        if (!this.valueMap.containsKey(dataSet.getElementTag())) {
            this.addValue(dataSet.getElementTag(), dataSet.getDefaultValue());
        }
    }

    public void addValue(String tag, Object value) {
        if (value == null) {
            return;
        }
        this.valueMap.put(tag, value);
    }

    public boolean hasChanges() {
        return this.hasValueChanges() || this.hasDataSetChanges();
    }

    public boolean hasDataSetChanges() {
        return !this.dataSetMap.isEmpty();
    }

    public boolean hasValueChanges() {
        return !this.valueMap.isEmpty();
    }

    public Collection<String> getValueTags() {
        return this.valueMap.keySet();
    }

    public Collection<String> getDataSetTags() {
        return this.setElementTagMap.keySet();
    }

    public Collection<String> getDataSetElementTags() {
        return this.setElementTagMap.values();
    }

    public Object getValue(String tag) {
        return this.valueMap.get(tag);
    }

    public boolean contains(String tag) {
        return this.valueMap.containsKey(tag);
    }

    public DataSet getDataSet(String tag) {
        String setTag = ParameterType.findSetTag(tag);
        return this.dataSetMap.get(setTag);
    }

    public Map<String, Object> getValueMap() {
        return Collections.unmodifiableMap(this.valueMap);
    }

    public Map<String, DataSet> getDataSetMap() {
        return Collections.unmodifiableMap(this.dataSetMap);
    }

    public void applyChanges() {
        this.context.addChange(this);
    }

    protected void removeChange(String tag) {
        String elementTag = ParameterType.findElementTag(tag);
        String setTag = ParameterType.findSetTag(tag);
        this.dataSetMap.remove(elementTag);
        this.dataSetMap.remove(setTag);
        this.valueMap.remove(elementTag);
    }

    protected void removeChanges(Collection<String> tagsToRemove) {
        for (String tag : tagsToRemove) {
            this.removeChange(tag);
        }
    }

    public static Object getValue(String tag, Collection<ContextChange> changes) {
        for (ContextChange c : changes) {
            Object v = c.getValue(tag);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    public String toString() {
        return "ContextChange [valueMap=" + this.valueMap + ", dataSetMap=" + this.dataSetMap + ", setElementTagMap=" + this.setElementTagMap + ", context=" + this.context + ", causeTag=" + this.causeTag + "]";
    }
}

