/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.page1;

import com.freescale.s32ds.cross.core.model.HWModel;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.GeneralContext;
import com.freescale.s32ds.cross.core.model.context.ProcessorConfiguration;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import com.freescale.s32ds.cross.core.model.registry.ModelRegistry;
import com.freescale.s32ds.cross.wizard.INewProjectLocationSource;
import com.freescale.s32ds.cross.wizard.Messages;
import com.freescale.s32ds.cross.wizard.S32DSAbstractWizard;
import com.freescale.s32ds.cross.wizard.S32DSMultiProjectWizard;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import com.freescale.s32ds.cross.wizard.page1.IPage1Manager;
import com.freescale.s32ds.cross.wizard.page1.Page1Manager;
import com.freescale.s32ds.cross.wizard.page2.S32DSMultiPageTwo;
import com.nxp.s32ds.ext.ide.resources.IdeValidators;
import com.nxp.s32ds.ext.rcp.databinding.validation.CompositeValidator;
import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class S32DSMultiPageOne
extends WizardPage
implements INewProjectLocationSource {
    private static final String PAGE_NAME = Messages.S32DSMultiPageOne_page_name;
    private static final String MULTI = "MULTI: ";
    private final Map<String, S32DSMultiPageTwo> exepages = new HashMap<String, S32DSMultiPageTwo>();
    private final Map<String, S32DSMultiPageTwo> libpages = new HashMap<String, S32DSMultiPageTwo>();
    private IPage1Manager pageManager;
    private final CompositeValidator compositeNameValidator = new CompositeValidator(IdeValidators.getNameValidators());
    private final CompositeValidator compositePathValidator = new CompositeValidator(IdeValidators.getPathValidators());

    public S32DSMultiPageOne(String pageName, S32DSAbstractWizard wizard) {
        super(pageName, "Create a S32 Design Studio Project", null);
        this.setWizard(wizard);
        this.setPageComplete(false);
        wizard.getContext().initData();
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.initializeDialogUnits((Control)parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.pageManager = new Page1Manager(this, this.getContext(), composite);
        this.pageManager.createContents(this.getWizard().getType());
        this.setButtonLayoutData(this.pageManager.getLocationArea().getBrowseButton());
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), S32DSWizardPlugin.makeHelpContextId(this.getWizard().getType(), 1));
    }

    public void setVisible(boolean visible) {
        this.getControl().setVisible(visible);
        if (visible) {
            this.getContext().getCurrentContext().reset();
            this.resetPages();
            this.pageManager.setFocus();
        }
    }

    public GridData setButtonLayoutData(Button button) {
        return super.setButtonLayoutData(button);
    }

    protected S32DSMultiPageTwo createPageTwoExec(String pageName, ProcessorContext execProcessorContext, S32DSMultiProjectWizard wizard) {
        return new S32DSMultiPageTwo(pageName, this.getWizard(), execProcessorContext);
    }

    protected S32DSMultiPageTwo createPageTwoLib(String pageName, ProcessorContext libProcessorContext, S32DSMultiProjectWizard wizard) {
        return new S32DSMultiPageTwo(pageName, this.getWizard(), libProcessorContext);
    }

    protected S32DSMultiPageTwo createPageTwo(String pageName, ProcessorContext context) {
        return new S32DSMultiPageTwo(pageName, this.getWizard(), context);
    }

    public IWizardPage getNextPage() {
        ProcessorContext processorContext = this.getContext().getCurrentProcessorContext();
        for (CProjectContext projectContext : processorContext.getProjectContexts()) {
            if (projectContext.getTemplate() == null || !this.validatePage()) continue;
            return this.getPageTwo(processorContext);
        }
        return null;
    }

    private S32DSMultiPageTwo getPageTwo(ProcessorContext processor) {
        if (processor == null) {
            return null;
        }
        S32DSMultiPageTwo pageTwo = this.getCreatePageTwo(processor);
        String projectName = this.getProjectName();
        pageTwo.setProjectName(projectName);
        return pageTwo;
    }

    private S32DSMultiPageTwo getCreatePageTwo(ProcessorContext processorContext) {
        boolean executable = this.getContext().isExecutable();
        Map<String, S32DSMultiPageTwo> pagesMap = executable ? this.exepages : this.libpages;
        S32DSMultiPageTwo pageTwo = pagesMap.get(processorContext.getKey());
        if (pageTwo == null) {
            pageTwo = executable ? this.createPageTwoExec(PAGE_NAME, processorContext, this.getWizard()) : this.createPageTwoLib(PAGE_NAME, processorContext, this.getWizard());
            pagesMap.put(processorContext.getKey(), pageTwo);
        }
        return pageTwo;
    }

    public S32DSMultiProjectWizard getWizard() {
        return (S32DSMultiProjectWizard)super.getWizard();
    }

    public boolean isCurrentPage() {
        return super.isCurrentPage();
    }

    public void setLabel(Composite c, String s) {
        Label l1 = new Label(c, 16384);
        l1.setLayoutData((Object)new GridData(16384));
        l1.setText(s);
        l1.setFont(c.getParent().getFont());
    }

    protected boolean filterProjectTypes(IProjectType p) {
        return p.getId().endsWith(this.getContext().isExecutable() ? ".exe" : ".lib");
    }

    public URI getLocationURI() {
        return this.pageManager.getLocationArea().getProjectLocationURI();
    }

    public String getProjectName() {
        return this.getContext().getProjectBaseName();
    }

    @Override
    public String getProjectLocation() {
        if (!this.useDefaults()) {
            return Paths.get(this.getLocationURI()).toString();
        }
        return null;
    }

    public boolean useDefaults() {
        return this.pageManager.getLocationArea().isDefault();
    }

    public IProject getProjectHandle() {
        String projectName = this.getProjectName();
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    public boolean validatePage() {
        IStatus status = null;
        String error = null;
        this.setMessage(null);
        String projectBaseName = this.pageManager.getProjectBaseName();
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append(this.pageManager.getLocationArea().getProjectLocation());
        if (this.useDefaults()) {
            pathBuilder.append(File.separator).append(projectBaseName);
        }
        String fullPath = pathBuilder.toString();
        if (this.getContext().isMulticore()) {
            for (CProjectContext pc : this.getContext().getCurrentProcessorContext().getProjectContexts()) {
                String name = projectBaseName == null || projectBaseName.isEmpty() ? "" : pc.getProjectName();
                status = this.validateProjNamePath(name, fullPath);
                if (status.isOK()) continue;
                this.setErrorMessage(MULTI + status.getMessage());
                return false;
            }
        } else {
            status = this.validateProjNamePath(projectBaseName, fullPath);
            if (!status.isOK()) {
                this.setErrorMessage(status.getMessage());
                return false;
            }
        }
        ProcessorConfiguration pConfiguration = this.getWizard().getContext().getCurrentProcessorConfiguration();
        if (pConfiguration == null) {
            error = Messages.S32DSMultiPageOne_data_not_init;
        } else if (pConfiguration.getCoreNatureConfigurations().isEmpty()) {
            error = Messages.S32DSMultiPageOne_no_templates;
        } else if (this.pageManager.getSelectedProcessor() == null) {
            error = Messages.S32DSMultiPageOne_processor_not_selected;
        } else if (this.getContext().getSelectedToolChains().size() == 0) {
            error = Messages.S32DSMultiPageOne_no_toolchains;
        }
        if (error != null) {
            this.setErrorMessage(error);
            return false;
        }
        IWorkspace wsp = ResourcesPlugin.getWorkspace();
        if (!this.useDefaults() && !(status = wsp.validateProjectLocationURI(this.getProjectHandle(), this.getLocationURI())).isOK()) {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private IStatus validateProjNamePath(String name, String path) {
        IStatus status = this.compositeNameValidator.validate((Object)name);
        if (!status.isOK()) {
            return status;
        }
        status = this.compositePathValidator.validate((Object)path);
        if (!status.isOK()) {
            return status;
        }
        return status;
    }

    public static void showError(String h, String s) {
        S32DSMultiPageOne.showMessage(h, s, 1, false);
    }

    public static void showMessage(String h, String s) {
        S32DSMultiPageOne.showMessage(h, s, 2, false);
    }

    public static void showMessage(String h, String s, int sev, boolean isSheet) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        shell.getDisplay().syncExec(() -> {
            boolean bl2 = MessageDialog.open((int)sev, (Shell)shell, (String)h, (String)s, (int)(isSheet ? 0x10000000 : 0));
        });
    }

    protected GeneralContext getContext() {
        return this.getWizard().getContext();
    }

    public ModelRegistry getRegistry() {
        return this.getContext().getRegistry();
    }

    protected HWModel getModel() {
        return this.getWizard().getModel();
    }

    public void resetPages() {
        this.exepages.clear();
        this.libpages.clear();
    }
}

