/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.checkers.sdk.compatibility.SDKCompatibilityChecker;
import com.freescale.s32ds.cross.sdk.internal.FilterOptions;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class IconProvider {
    private static final SDKCompatibilityChecker CHECKER = new SDKCompatibilityChecker();
    public static final String OK = "OK";
    public static final String DATA_TAG = "ATTACH";
    private static final Image PL_ICON = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD");
    private static final Image ER_ICON = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
    private static final String ID = "com.freescale.s32ds.cross.sdk.support";
    private static final Image CHIP_ICON = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)"com.freescale.s32ds.cross.sdk.support"), (IPath)new Path("icons/err_chip.png"), null)).createImage();
    private static final Image DUPL_ICON = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)"com.freescale.s32ds.cross.sdk.support"), (IPath)new Path("icons/err_dupl.png"), null)).createImage();
    private static final Image FILE_ICON = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)"com.freescale.s32ds.cross.sdk.support"), (IPath)new Path("icons/err_file.png"), null)).createImage();
    private static final Image FONT_ICON = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)"com.freescale.s32ds.cross.sdk.support"), (IPath)new Path("icons/err_font.png"), null)).createImage();
    private static final Image TOOL_ICON = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)"com.freescale.s32ds.cross.sdk.support"), (IPath)new Path("icons/err_tool.png"), null)).createImage();
    private static final Image NONE_ICON = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)"com.freescale.s32ds.cross.sdk.support"), (IPath)new Path("icons/err_none.png"), null)).createImage();
    private static final Image[] IMAGES;
    private static final String[] TOOLTIPS;
    private static final int UNKNOWN = -1;
    private static final int STATE_DETACHED = 0;
    private static final int STATE_ATTACHED = 1;
    private static final int STATE_CORE = 2;
    private static final int STATE_DUPL = 3;
    private static final int STATE_FILE = 4;
    private static final int STATE_LANG = 5;
    private static final int STATE_TOOL = 6;
    private static final int STATE_NONE = 7;
    private static final int STATE_NULL = 8;
    private final IProject project;
    private final String PRJ_NAME;
    private final IToolChain tcCFG;
    private final int num;

    static {
        Image[] imageArray = new Image[9];
        imageArray[1] = PL_ICON;
        imageArray[2] = CHIP_ICON;
        imageArray[3] = DUPL_ICON;
        imageArray[4] = FILE_ICON;
        imageArray[5] = FONT_ICON;
        imageArray[6] = TOOL_ICON;
        imageArray[7] = NONE_ICON;
        imageArray[8] = ER_ICON;
        IMAGES = imageArray;
        TOOLTIPS = new String[]{Messages.IconProvider_0, Messages.IconProvider_1, Messages.IconProvider_2, Messages.IconProvider_3, Messages.IconProvider_4, Messages.IconProvider_5, Messages.IconProvider_6, Messages.IconProvider_7, Messages.SDKManagementWidget_Error};
    }

    public IconProvider(IConfiguration cfg, int _num) {
        this.project = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)cfg).getProjectDescription().getProject();
        this.PRJ_NAME = this.project == null ? "NULL" : String.valueOf(this.project.getLocation().toOSString()) + '/';
        this.tcCFG = IconProvider.getSuper(cfg.getToolChain());
        this.num = _num;
    }

    public Image getImageFor(ViewerCell cell, Boolean[] d) {
        ISDK sdk = (ISDK)cell.getElement();
        return IMAGES[this.getIndexFor(sdk, d, cell.getItem())];
    }

    public String getToolTipFor(ISDK sdk, Boolean[] d) {
        return TOOLTIPS[this.getIndexFor(sdk, d, null)];
    }

    private static IToolChain getSuper(IToolChain tc) {
        if (tc != null) {
            if (FilterOptions.isDigitTail(tc.getId())) {
                tc = tc.getSuperClass();
            }
            return tc;
        }
        return null;
    }

    private int getIndexFor(ISDK sdk, Boolean[] d, Widget item) {
        int res;
        if (item != null) {
            item.setData(DATA_TAG + this.num, null);
        }
        if ((res = this.checkAvailable(sdk, d, item)) != -1) {
            return res;
        }
        if (!CHECKER.checkLang(this.project, sdk)) {
            return 5;
        }
        if (!CHECKER.checkCore(this.project, sdk)) {
            return 2;
        }
        if (!CHECKER.checkTool(this.project, sdk, this.tcCFG)) {
            return 6;
        }
        if (!sdk.isAvailable()) {
            return 7;
        }
        if (d == null) {
            return 8;
        }
        if (d[this.num] == null) {
            d[this.num] = Boolean.FALSE;
        }
        if (item != null) {
            item.setData(DATA_TAG + this.num, (Object)OK);
        }
        return d[this.num] != false ? 1 : 0;
    }

    private int checkAvailable(ISDK sdk, Boolean[] d, Widget item) {
        if (d != null && d.length > this.num && d[this.num] != null) {
            Boolean[] booleanArray = d;
            int n = d.length;
            int n2 = 0;
            while (n2 < n) {
                Boolean b = booleanArray[n2];
                if (b != null && b.booleanValue()) {
                    return -1;
                }
                ++n2;
            }
        }
        if (this.project != null) {
            java.nio.file.Path p = Paths.get(String.valueOf(this.PRJ_NAME) + sdk.getName(), new String[0]);
            if (Files.isRegularFile(p, new LinkOption[0])) {
                return 4;
            }
            if (Files.isDirectory(p, new LinkOption[0]) && !this.project.getFolder(sdk.getName()).exists()) {
                return 3;
            }
        }
        return -1;
    }
}

