/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.internal.SDKAttach;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SDKAttachChecker {
    public static final SDKAttachChecker INSTANCE = new SDKAttachChecker();

    public IStatus checkPreAttach(ISDK sdk, IProject project) {
        IStatus result = Status.OK_STATUS;
        result = this.checkAttachSDKWithSameName(sdk, project);
        return result;
    }

    public IStatus checkPostAttach(ISDK sdk, IProject project) {
        IStatus result = Status.OK_STATUS;
        return result;
    }

    private IStatus checkAttachSDKWithSameName(ISDK sdk, IProject project) {
        String sdkName = sdk.getName();
        if (SDKAttach.getAttached(project).stream().anyMatch(s -> s.getName().equals(sdkName) && !s.getVersion().equals(sdk.getVersion()))) {
            String message = NLS.bind((String)Messages.SDKAttach_confirm_attach_sdk_with_same_name, (Object[])new String[]{project.getName(), sdkName, sdk.getBriefInfo()});
            return new Status(4, SDKSupportPlugin.getUniqueIdentifier(), 1001, message, null);
        }
        return Status.OK_STATUS;
    }
}

