/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.debug.ui;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class LaunchConfigurationDelegate2Wrapper
implements ILaunchConfigurationDelegate2 {
    private final ILaunchConfigurationDelegate2 delegate;

    public LaunchConfigurationDelegate2Wrapper(ILaunchConfigurationDelegate2 delegate) {
        this.delegate = delegate;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.delegate.launch(configuration, mode, launch, monitor);
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.delegate.getLaunch(configuration, mode);
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return this.delegate.buildForLaunch(configuration, mode, monitor);
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return this.delegate.finalLaunchCheck(configuration, mode, monitor);
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (!this.delegate.preLaunchCheck(configuration, mode, monitor)) {
            return false;
        }
        ArrayList<ILaunch> launches = new ArrayList<ILaunch>(configuration){
            {
                ILaunch[] iLaunchArray = DebugPlugin.getDefault().getLaunchManager().getLaunches();
                int n = iLaunchArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunch launch = iLaunchArray[n2];
                    if (launch != null && launch.getLaunchConfiguration() != null && launch.getLaunchConfiguration().equals(iLaunchConfiguration) && launch.getProcesses().length > 0) {
                        this.add(launch);
                    }
                    ++n2;
                }
            }
        };
        if (launches.isEmpty()) {
            return true;
        }
        Action action = Action.ask();
        if (action.killOld) {
            for (ILaunch launch : launches) {
                launch.terminate();
            }
        }
        return !action.killNew;
    }

    private static enum Action {
        OLD("Old", false, true),
        NEW("New", true, false),
        NONE("None", true, true);

        public static final Action defaultAction;
        public final String label;
        public final boolean killOld;
        public final boolean killNew;

        static {
            defaultAction = OLD;
        }

        private Action(String label, boolean killOld, boolean killNew) {
            this.label = label;
            this.killOld = killOld;
            this.killNew = killNew;
        }

        private static String[] labels() {
            return new ArrayList<String>(){
                {
                    Action[] actionArray = Action.values();
                    int n = actionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Action action = actionArray[n2];
                        this.add(action.label);
                        ++n2;
                    }
                }
            }.toArray(new String[Action.values().length]);
        }

        public static Action ask() {
            return (Action)((Object)new ArrayList<Action>(){
                {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            int r = new MessageDialog(null, "Warning", null, "Another debug session already exists for this configuration. Which session would you like to continue with?", 4, Action.labels(), defaultAction.ordinal()).open();
                            this.add(Action.values()[r == -1 ? defaultAction.ordinal() : r]);
                        }
                    });
                }
            }.iterator().next());
        }
    }
}

