/*
 * main implementation: use this 'C++' sample to create your own application
 *
 */

#include "$(DEVICE_NAME).h"

#include <stdio.h>

#if defined (__ghs__)
    #define __INTERRUPT_SVC  __interrupt
    #define __NO_RETURN _Pragma("ghs nowarning 111")
#elif defined (__ICCARM__)
    #define __INTERRUPT_SVC  __svc
    #define __NO_RETURN _Pragma("diag_suppress=Pe111")
#elif defined (__GNUC__)
    #define __INTERRUPT_SVC  __attribute__ ((interrupt ("SVC")))
    #define __NO_RETURN
#else
    #define __INTERRUPT_SVC
    #define __NO_RETURN
#endif

class CCounter {
private:
    static const int m_limit = 1000000;
    int m_counter;

public:
    CCounter() : m_counter(0) {
    };
    CCounter(const CCounter& counter) {
        m_counter = counter.m_counter;
    }
    void increment() {
        m_counter++;
    };
    int get() {
        return m_counter;
    };
    void set(int value) {
        m_counter = value;
    };
    int getLimit() {
        return m_limit;
    };
};

CCounter myAccumulator;
CCounter myCounter;

int main()
{
    printf ("Program started\n");

    for(;;) {
        myCounter.increment();
        if (myCounter.get() > myCounter.getLimit())
            {
            __asm volatile ("svc 0");
            printf ("Counter limit reached\n");
            myCounter.set(0);
            }
    }

    /* to avoid the warning message for GHS and IAR: statement is unreachable*/
    __NO_RETURN
    return 0;
}

extern "C" {

    __INTERRUPT_SVC void SVC_Handler() {
        myAccumulator.set(myAccumulator.get() + myCounter.get());
    }
}

