/*========================================================================*
 * COPYRIGHT:                                                             *
 *  Freescale Semiconductor, INC. All Rights Reserved. You are hereby     *
 *  granted a copyright license to use, modify, and distribute the        *
 *  SOFTWARE so long as this entire notice is retained without alteration *
 *  in any modified and/or redistributed versions, and that such modified *
 *  versions are clearly identified as such. No licenses are granted by   *
 *  implication, estoppel or otherwise under any patentsor trademarks     *
 *  of Freescale Semiconductor, Inc. This software is provided on an      *
 *  "AS IS" basis and without warranty.                                   *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, Freescale          *
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,    *
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A      *
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD  *
 *  TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY     *
 *  ACCOMPANYING WRITTEN MATERIALS.                                       *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, IN NO EVENT        *
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER    *
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,  *
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER         *
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.  *
 *                                                                        *
 *  Freescale Semiconductor assumes no responsibility for the             *
 *  maintenance and support of this software                              *
 *                                                                        *
 **************************************************************************/

    .arch armv7-a
    .align 4
    .globl   Reset_Handler
    .type    Reset_Handler, %function
    .section .startup_a5, "ax"

Reset_Handler:
    /* set up SVC mode stack pointer */
    .extern __StackTop
    ldr     sp, =__StackTop

    /* set VBAR to vector table address */
    .extern vt
    ldr     r0, =vt
    mcr     p15, 0, r0, c12, c0, 0

    .extern init_data
    bl      init_data

#if defined (__VFP_FP__) && !defined (__SOFTFP__)
  /* Permit access to VFP/NEON, registers by modifying CPACR */
  mrc     p15,0,r1,c1,c0,2
  orr     r1,r1,#0x00f00000
  mcr     p15,0,r1,c1,c0,2

  /* Ensure that subsequent instructions occur in the context of VFP/NEON access permitted */
  isb

  /* Enable VFP/NEON */
  vmrs    r1,fpexc
  orr     r1,r1,#0x40000000
  vmsr    fpexc,r1

  /* Initialise VFP/NEON registers to 0 */
  mov     r2,#0

  /* Initialise D16 registers to 0 */
  vmov    d0, r2,r2
  vmov    d1, r2,r2
  vmov    d2, r2,r2
  vmov    d3, r2,r2
  vmov    d4, r2,r2
  vmov    d5, r2,r2
  vmov    d6, r2,r2
  vmov    d7, r2,r2
  vmov    d8, r2,r2
  vmov    d9, r2,r2
  vmov    d10,r2,r2
  vmov    d11,r2,r2
  vmov    d12,r2,r2
  vmov    d13,r2,r2
  vmov    d14,r2,r2
  vmov    d15,r2,r2

#if (defined(__ARM_NEON) && (__ARM_NEON == 1))
  /* Initialise D32 registers to 0 */
  vmov    d16,r2,r2
  vmov    d17,r2,r2
  vmov    d18,r2,r2
  vmov    d19,r2,r2
  vmov    d20,r2,r2
  vmov    d21,r2,r2
  vmov    d22,r2,r2
  vmov    d23,r2,r2
  vmov    d24,r2,r2
  vmov    d25,r2,r2
  vmov    d26,r2,r2
  vmov    d27,r2,r2
  vmov    d28,r2,r2
  vmov    d29,r2,r2
  vmov    d30,r2,r2
  vmov    d31,r2,r2
#endif

  /* Initialise FPSCR to a known state */
  vmrs    r1,fpscr
  /* Mask off all bits that do not have to be preserved. Non-preserved bits can/should be zero. */
  ldr     r2,=0x00086060
  and     r1,r1,r2
  vmsr    fpscr,r1
#endif


    /* jump to startup */
#ifndef __START
#ifdef __EWL__
#define __START  __thumb_startup
#else
#define __START _start
#endif
#endif
    bl	__START

trap:
    b       trap
