/*****************************************************************************
 *
 * Copyright (c) 2015-2016 Freescale Semiconductor, Inc.
 * Copyright 2017-2019 NXP
 * All Rights Reserved
 *
 *****************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

#include "derivative.h"

extern unsigned int __bss_start__;
extern unsigned int __bss_end__;

void init_data (void)
{
    uint32_t* bss_begin = (uint32_t*)&__bss_start__;
    uint32_t* bss_end   = (uint32_t*)&__bss_end__;
    uint8_t * data_ram, * data_rom, * data_rom_end;
   
    uint32_t n;
    
    while(bss_begin < bss_end)
    {
        *bss_begin = 0;
        bss_begin++;
    }
    
    /* Get the addresses for the .data section (initialized data section) */

    extern  uint32_t __DATA_ROM[];
    extern  uint32_t __DATA_RAM[];
    extern  uint32_t __DATA_END[];
    data_ram = (uint8_t *)__DATA_RAM;
    data_rom = (uint8_t *)__DATA_ROM;
    data_rom_end  = (uint8_t *)__DATA_END;
    n = data_rom_end - data_rom;

    /* Copy initialized data from ROM to RAM */
    while (n--)
    {
        *data_ram++ = *data_rom++;
    }
}

