/*************************************************************************
*
* Freescale Confidential Proprietary
*
* Copyright (c) 2012-2013 Freescale Semiconductor;
* All Rights Reserved
*
**************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************/

//*** includes ****************************************************************
#include "VG/openvg.h"
#include "VG/vgext.h"

#include "ovgapp.h"
#include "picdata_fsl.h"

//*** defines *****************************************************************

#define IMAGE_SCALE		0.7F
const VGfloat clear_color[2][4] = {{0.0F, 0.0F, 1.0F, 1.0F}, {1.0F, 0.0F, 0.0F, 1.0F}}; 

//*** locals ******************************************************************
static VGPaint	fillPaint[2];
static VGImage	image[2];
static float	rotation[2];
static VGint 	x[2], sx[2], y[2], sy[2];

//*****************************************************************************

void OvgApp_Init(int id, int width, int height)
{
	VGfloat fillColor[4] = {1.0f, 1.0F, 1.0F, 1.0F};
                                     
    vgSeti(VG_RENDERING_QUALITY, VG_RENDERING_QUALITY_BETTER);
      
    fillPaint[id] = vgCreatePaint();    
	vgSetParameteri(fillPaint[id], VG_PAINT_TYPE, VG_PAINT_TYPE_COLOR);
    vgSetParameterfv(fillPaint[id], VG_PAINT_COLOR, 4, fillColor);
    vgSetPaint(fillPaint[id], VG_FILL_PATH);
    
    vgSeti(VG_BLEND_MODE, VG_BLEND_SRC_OVER);
	
    image[id] = vgCreateImage(VG_sRGBA_8888, picdata_fsl_width, picdata_fsl_height, VG_IMAGE_QUALITY_BETTER);
    vgImageSubData(image[id], picdata_fsl, picdata_fsl_width * 4, VG_sRGBA_8888, 0, 0, picdata_fsl_width, picdata_fsl_height); 
	
	rotation[id] = 0.0F;
    
    if (id == 0)
    {
        x[id] = y[id] = 0;
    }
    else
    {
        x[id] = width;
        y[id] = height;
    }
    
	sx[id] = sy[id] = 1;
} // OvgApp_Init()

/*--------------------------------------------------------------------------*/

void OvgApp_Draw(int id, int width, int height)
{
    int sign = (id == 0)? 1 : -1;
    
	++rotation[id];
	
	x[id] += sign * sx[id];
	y[id] += sign * sy[id];
	
	if ((x[id] > width) || (x[id] < 0))
	{
		sx[id] = -sx[id];
	}
	
	if ((y[id] > height) || (y[id] < 0))
	{
		sy[id] = -sy[id];
	}

    vgSetfv(VG_CLEAR_COLOR, 4, clear_color[id]);
    vgClear(0, 0, width, height);
    
    vgSeti(VG_MATRIX_MODE, VG_MATRIX_IMAGE_USER_TO_SURFACE);
	vgLoadIdentity();
	vgTranslate(x[id], y[id]);
	vgRotate(rotation[id]);
	vgTranslate(-picdata_fsl_width * IMAGE_SCALE * 0.5F, -picdata_fsl_height * IMAGE_SCALE * 0.5F);
	vgScale(IMAGE_SCALE, IMAGE_SCALE);
	
    vgDrawImage(image[id]);
	vgFinish();
} // OvgApp_Draw()

/*--------------------------------------------------------------------------*/

void OvgApp_Close(int id)
{
    vgDestroyPaint(fillPaint[id]);
    vgDestroyImage(image[id]);
} // OvgApp_Close()

//*** EOF *********************************************************************
