; ---------------------------------------------------------------------------------------
;  @file:    startup_SKEAZN84.s
;  @purpose: @purpose: CMSIS Cortex-M0P Core Device Startup File
;            SKEAZN84
;  @version: 1.7
;  @date:    2015-10-21
;  @build:   b151027
; ---------------------------------------------------------------------------------------
;
; Copyright (c) 1997 - 2015 , Freescale Semiconductor, Inc.
; All rights reserved.
;
; Redistribution and use in source and binary forms, with or without modification,
; are permitted provided that the following conditions are met:
;
; o Redistributions of source code must retain the above copyright notice, this list
;   of conditions and the following disclaimer.
;
; o Redistributions in binary form must reproduce the above copyright notice, this
;   list of conditions and the following disclaimer in the documentation and/or
;   other materials provided with the distribution.
;
; o Neither the name of Freescale Semiconductor, Inc. nor the names of its
;   contributors may be used to endorse or promote products derived from this
;   software without specific prior written permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
; WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
; DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
; ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
; (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
; ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
; (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
; SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;*****************************************************************************
;* Version: GCC for ARM Embedded Processors                                  *
;*****************************************************************************
    .text

    .need DefaultISR
    .globl DefaultISR

    .thumb

    .section .isr_vector, "a"
    .align 2
    .globl __isr_vector
__isr_vector:
    .long   __StackTop                                      ; Top of Stack 
    .long   Reset_Handler                                   ; Reset Handler 
    .long   NMI_Handler                                     ; NMI Handler
    .long   HardFault_Handler                               ; Hard Fault Handler
    .long   0                                               ; Reserved
    .long   0                                               ; Reserved
    .long   0                                               ; Reserved
    .long   0                                               ; Reserved
    .long   0                                               ; Reserved
    .long   0                                               ; Reserved
    .long   0                                               ; Reserved
    .long   SVC_Handler                                     ; SVCall Handler
    .long   0                                               ; Reserved
    .long   0                                               ; Reserved
    .long   PendSV_Handler                                  ; PendSV Handler
    .long   SysTick_Handler                                 ; SysTick Handler

                                                            ; External Interrupts
    .long   Reserved16_IRQHandler                           ; Reserved interrupt 16
    .long   Reserved17_IRQHandler                           ; Reserved interrupt 17
    .long   Reserved18_IRQHandler                           ; Reserved interrupt 18
    .long   Reserved19_IRQHandler                           ; Reserved interrupt 19
    .long   Reserved20_IRQHandler                           ; Reserved interrupt 20
    .long   FTMRE_IRQHandler                                ; FTMRE command complete/read collision interrupt
    .long   LVD_LVW_IRQHandler                              ; Low Voltage Detect, Low Voltage Warning
    .long   IRQ_IRQHandler                                  ; External interrupt
    .long   I2C0_IRQHandler                                 ; I2C0 interrupt
    .long   Reserved25_IRQHandler                           ; Reserved interrupt 25
    .long   SPI0_IRQHandler                                 ; SPI0 interrupt
    .long   Reserved27_IRQHandler                           ; Reserved interrupt 27
    .long   UART0_IRQHandler                                ; UART0 status/error interrupt
    .long   Reserved29_IRQHandler                           ; Reserved interrupt 29
    .long   Reserved30_IRQHandler                           ; Reserved interrupt 30
    .long   ADC0_IRQHandler                                 ; ADC0 interrupt
    .long   ACMP0_IRQHandler                                ; ACMP0 interrupt
    .long   FTM0_IRQHandler                                 ; FTM0 Single interrupt vector for all sources
    .long   Reserved34_IRQHandler                           ; Reserved interrupt 34
    .long   FTM2_IRQHandler                                 ; FTM2 Single interrupt vector for all sources
    .long   RTC_IRQHandler                                  ; RTC overflow
    .long   ACMP1_IRQHandler                                ; ACMP1 interrupt
    .long   PIT_CH0_IRQHandler                              ; PIT CH0 overflow
    .long   PIT_CH1_IRQHandler                              ; PIT CH1 overflow
    .long   KBI0_IRQHandler                                 ; Keyboard interrupt 0
    .long   KBI1_IRQHandler                                 ; Keyboard interrupt 1
    .long   Reserved42_IRQHandler                           ; Reserved interrupt 42
    .long   ICS_IRQHandler                                  ; ICS interrupt
    .long   Watchdog_IRQHandler                             ; WDOG Interrupt
    .long   PWT_IRQHandler                                  ; Pulse Width Timer Interrupt
    .long   Reserved46_IRQHandler                           ; Reserved interrupt 46
    .long   Reserved47_IRQHandler                           ; Reserved interrupt 47


    .size    __isr_vector, . - __isr_vector

; Flash Configuration
    .section .FlashConfig, "a"
    .long 0xFFFFFFFF     ; 8 bytes backdoor comparison key
    .long 0xFFFFFFFF     ;
    .long 0xFFFFFFFF     ; 4 bytes program flash protection bytes
    .long 0xFFFEFF87      ; FDPROT:FEPROT:FOPT:FSEC(0xFE=unsecured)

    .text
    .thumb

; Reset Handler
    .thumb
    .align 4
    .globl   Reset_Handler
    .weak    Reset_Handler
    .type    Reset_Handler, $function
Reset_Handler:
    cpsid   i               ; Mask interrupts

    ; Init the rest of the registers
    ldr     r1,=0
    ldr     r2,=0
    ldr     r3,=0
    ldr     r4,=0
    ldr     r5,=0
    ldr     r6,=0
    ldr     r7,=0
    mov     r8,r7
    mov     r9,r7
    mov     r10,r7
    mov     r11,r7
    mov     r12,r7

    ; Initialize the stack pointer
    ldr     r0,=__StackTop
    mov     r13,r0

#ifndef __NO_SYSTEM_INIT
    ; Call the CMSIS system init routine
    ldr     r0,=SystemInit
    blx     r0
#endif

    ; Init .data and .bss sections
    cpsie   i               ; Unmask interrupts

	bl    init_data

#ifndef __NO_STARTUP_CLEAR_BSS
;     This part of work usually is done in C library startup code. Otherwise,
;     define this macro to enable it in this startup.
;
;     Loop to zero out BSS section, which uses following symbols
;     in linker script:
;      __bss_start__: start of BSS section. Must align to 4
;      __bss_end__: end of BSS section. Must align to 4 

    ldr r1, =__bss_start__
    ldr r2, =__bss_end__

    subs    r2, r1
    ble .LC3

    movs    r0, 0
.LC2:
    str r0, [r1, r2]
    subs    r2, 4
    bge .LC2
.LC3:

#endif


    bl    main
    .ltorg
    .size Reset_Handler, . - Reset_Handler

    .align	1
    .thumb
    .weak	Default_Handler
    .type    Default_Handler, $function
Default_Handler:
     b	.
     .size	Default_Handler, . - Default_Handler

;    Macro to define default handlers. Default handler
;    will be weak symbol and just dead loops. They can be
;    overwritten by other handlers
     .macro	def_irq_handler	handler_name
     .weak	handler_name
     .set	handler_name, Default_Handler
     .endm

; Exception Handlers
    def_irq_handler    NMI_Handler
    def_irq_handler    HardFault_Handler
    def_irq_handler    SVC_Handler
    def_irq_handler    PendSV_Handler
    def_irq_handler    SysTick_Handler
    def_irq_handler    Reserved16_IRQHandler
    def_irq_handler    Reserved17_IRQHandler
    def_irq_handler    Reserved18_IRQHandler
    def_irq_handler    Reserved19_IRQHandler
    def_irq_handler    Reserved20_IRQHandler
    def_irq_handler    FTMRE_IRQHandler
    def_irq_handler    LVD_LVW_IRQHandler
    def_irq_handler    IRQ_IRQHandler
    def_irq_handler    I2C0_IRQHandler
    def_irq_handler    Reserved25_IRQHandler
    def_irq_handler    SPI0_IRQHandler
    def_irq_handler    Reserved27_IRQHandler
    def_irq_handler    UART0_IRQHandler
    def_irq_handler    Reserved29_IRQHandler
    def_irq_handler    Reserved30_IRQHandler
    def_irq_handler    ADC0_IRQHandler
    def_irq_handler    ACMP0_IRQHandler
    def_irq_handler    FTM0_IRQHandler
    def_irq_handler    Reserved34_IRQHandler
    def_irq_handler    FTM2_IRQHandler
    def_irq_handler    RTC_IRQHandler
    def_irq_handler    ACMP1_IRQHandler
    def_irq_handler    PIT_CH0_IRQHandler
    def_irq_handler    PIT_CH1_IRQHandler
    def_irq_handler    KBI0_IRQHandler
    def_irq_handler    KBI1_IRQHandler
    def_irq_handler    Reserved42_IRQHandler
    def_irq_handler    ICS_IRQHandler
    def_irq_handler    Watchdog_IRQHandler
    def_irq_handler    PWT_IRQHandler
    def_irq_handler    Reserved46_IRQHandler
    def_irq_handler    Reserved47_IRQHandler
    def_irq_handler    DefaultISR

    .end
