/* Linker file for GHS C Compiler */

DEFAULTS {
    HEAP_SIZE = 0x00000500
    STACK_SIZE = 0x00000400
}

CONSTANTS {
    SRAM_SIZE = 0x00004000
}

/* Specify the memory areas */
MEMORY
{
  SRAM             (RW)  : ORIGIN = 0x1FFFF000, LENGTH = SRAM_SIZE
}

/* Define output sections */
SECTIONS
{
  .interrupts :
  {
    __VECTOR_TABLE = .;
    . = ALIGN(4);
    "*(.isr_vector)"     /* Startup code */   
    . = ALIGN(4);
  } > SRAM

  /* The program code and other data goes into internal flash */
  .text :
  {
    . = ALIGN(4);
   "*(.text)"               /* .text sections (code) */
    "*(.text*)"              /* .text* sections (code) */
    "*(.intercall)" 
    "*(.interfunc)" 
    "*(.syscall)" 
    "*(.rodata)"             /* .rodata sections (constants, strings, etc.) */
    "*(.rodata*)"            /* .rodata* sections (constants, strings, etc.) */
    "*(.glue_7)"             /* glue arm to thumb code */
    "*(.glue_7t)"            /* glue thumb to arm code */
    "*(.eh_frame)"
    "*(.init)"
    "*(.fini)"
    . = ALIGN(4);
  } > SRAM

  .ARM.extab :
  {
    "*(.ARM.extab* .gnu.linkonce.armextab.*)"
  } > SRAM

  .ARM :
  {
    __exidx_start = .;
    "*(.ARM.exidx*)"
    __exidx_end = .;
  } > SRAM

 .ctors :
  {
    __CTOR_LIST__ = .;
    "*(.ctors.*)"
    "*(.ctors)"
    __CTOR_END__ = .;
  } > SRAM

  .dtors :
  {
    __DTOR_LIST__ = .;
    "*(.dtors.*)"
    "*(.dtors)"
    __DTOR_END__ = .;
  } > SRAM

  .preinit_array :
  {
    __preinit_array_start = .;
    "*(.preinit_array*)"
    __preinit_array_end = .;
  } > SRAM

  .init_array :
  {
    __init_array_start = .;
    "*(.init_array.*)"
    "*(.init_array*)"
    __init_array_end = .;
  } > SRAM

  .fini_array :
  {
    __fini_array_start = .;
    "*(.fini_array.*)"
    "*(.fini_array*)"
    __fini_array_end = .;
  } > SRAM

  __etext = .;    /* define a global symbol at end of code */
  __DATA_ROM = .; /* Symbol is used by startup for data initialization */

  /* reserve MTB memory at the beginning of SRAM */
  .mtb : /* MTB buffer address as defined by the hardware */
  {
    . = ALIGN(8);
    _mtb_start = .;
    KEEP(*(.mtb_buf)) /* need to KEEP Micro Trace Buffer as not referenced by application */
    . = ALIGN(8);
    _mtb_end = .;
  } > SRAM

  .data : AT(__DATA_ROM)
  {
    . = ALIGN(4);
    __DATA_RAM = .;
    __data_start__ = .;      /* create a global symbol at data start */
    "*(.data)"               /* .data sections */
    "*(.data*)"              /* .data* sections */
    "*(.jcr*)"
    . = ALIGN(4);
    __data_end__ = .;        /* define a global symbol at data end */
  } > SRAM

  /* Symbol is used by startup for data initialization */
  __DATA_END = __DATA_ROM + (__data_end__ - __data_start__);

  /* Uninitialized data section */
  .bss :
  {
    /* This is used by the startup in order to initialize the .bss section */
    . = ALIGN(4);
    __START_BSS = .;
    __bss_start__ = .;
    "*(.bss)"
    "*(.bss*)"
    "*(COMMON)"
    . = ALIGN(4);
    __bss_end__ = .;
    __END_BSS = .;
  } > SRAM

  _romp_at = __DATA_ROM + SIZEOF(.data);
  
  .heap :
  {
    . = ALIGN(8);
    __end__ = .;
    _end = .;
    PROVIDE(end = .);
    __HeapBase = .;
    . += HEAP_SIZE;
    __HeapLimit = .;
  } > SRAM

  .stack :
  {
    . = ALIGN(8);
    . += STACK_SIZE;
  } > SRAM

  __StackTop   = .;
  __StackLimit = __StackTop - STACK_SIZE;
  PROVIDE(__stack = __StackTop);

  .ARM.attributes :
  {
    *(.ARM.attributes)
  } 
  
}
