package com.freescale.s32ds.cross.sdk.s32k14x_0_8_5.pexconf;


import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ISDKHook;

public class PExConfigk142 implements ISDKHook {
	private static final int MODE_ALL = ISDKHook.STATE_ATTACH + ISDKHook.TIME_AFTER;

	public PExConfigk142() {
	}

	@Override
	public void stateChange(int mode, ISDK sdk, Object cfg, String path) {

		if (mode == MODE_ALL) {
			IProject curProject = getProject(cfg);
			if (curProject != null) {
				new PExConfigk142Adjuster(curProject).adjustPExConfiguration();
				ManagedBuildManager.saveBuildInfo(curProject, true);
			}
		}
	}

	private IProject getProject(Object cfg) {
		IProject curProject = null;
		if (cfg instanceof ICConfigurationDescription) {
			ICConfigurationDescription cfgd = (ICConfigurationDescription) cfg;
			return cfgd.getProjectDescription().getProject();
		} else if (cfg instanceof IConfiguration) {
			return (IProject) ((IConfiguration) cfg).getManagedProject().getOwner();
		} else {
			Activator.log(new IllegalArgumentException("Fail to invoke PExConfigk142 Hook")); //$NON-NLS-1$
		}
		return curProject;
	}
}