; ---------------------------------------------------------------------------------------
;  @file:    startup_S32V_M4.s
;  @purpose: CMSIS Cortex-M4 Core Device Startup File
;            S32V_M4
; ---------------------------------------------------------------------------------------
;
; Copyright (c) 1997 - 2015 , Freescale Semiconductor, Inc.
; All rights reserved.
;
; Redistribution and use in source and binary forms, with or without modification,
; are permitted provided that the following conditions are met:
;
; o Redistributions of source code must retain the above copyright notice, this list
;   of conditions and the following disclaimer.
;
; o Redistributions in binary form must reproduce the above copyright notice, this
;   list of conditions and the following disclaimer in the documentation and/or
;   other materials provided with the distribution.
;
; o Neither the name of Freescale Semiconductor, Inc. nor the names of its
;   contributors may be used to endorse or promote products derived from this
;   software without specific prior written permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
; WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
; DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
; ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
; (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
; ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
; (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
; SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;
; The modules in this file are included in the libraries, and may be replaced
; by any user-defined modules that define the PUBLIC symbol _program_start or
; a user defined start symbol.
; To override the cstartup defined in the library, simply add your modified
; version to the workbench project.
;
; The vector table is normally located at address 0.
; When debugging in RAM, it can be located in RAM, aligned to at least 2^6.
; The name "__vector_table" has special meaning for C-SPY:
; it is where the SP start value is found, and the NVIC vector
; table register (VTOR) is initialized to this address if != 0.
;
; Cortex-M version
;

        MODULE  ?cstartup

        ;; Forward declaration of sections.
        SECTION CSTACK:DATA:NOROOT(3)

        SECTION .intvec:CODE:ROOT(2)

        EXTERN  __iar_program_start
        EXTERN  SystemInit
        EXTERN  init_data_bss
		EXTERN __SRAM_START_ADDRESS__
		EXTERN __RAM_SIZE__
		EXTERN __TCM_DATA_START_ADDRESS__
		EXTERN __TCM_DATA_SIZE__
        PUBLIC  __vector_table
        PUBLIC  __Vectors
        PUBLIC  __Vectors_End
        PUBLIC  __Vectors_Size

        DATA

__vector_table
        DCD     sfe(CSTACK)
        DCD     Reset_Handler

        DCD     NMI_Handler                                   ;NMI Handler
        DCD     HardFault_Handler                             ;Hard Fault Handler
        DCD     MemManage_Handler                             ;MPU Fault Handler
        DCD     BusFault_Handler                              ;Bus Fault Handler
        DCD     UsageFault_Handler                            ;Usage Fault Handler

__Vectors_End

__Vectors       EQU   __vector_table
__Vectors_Size 	EQU   __Vectors_End - __Vectors


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Default interrupt handlers.
;;
        THUMB

        PUBWEAK Reset_Handler
        SECTION .text:CODE:REORDER:NOROOT(2)
Reset_Handler
        CPSID   I               ; Mask interrupts
        ;; Init the rest of the registers
        LDR     R1,=0
        LDR     R2,=0
        LDR     R3,=0
        LDR     R4,=0
        LDR     R5,=0
        LDR     R6,=0
        LDR     R7,=0
        MOV     R8,R7
        MOV     R9,R7
        MOV     R10,R7
        MOV     R11,R7
        MOV     R12,R7

        ;; Initialize the stack pointer
        LDR     R0, =sfe(CSTACK)
        MOV     R13,R0

; Disable Watchdog
    MOVW     R0,#0XA010   ; SWT0_SR (0X4000A010)
    MOVT     R0,#0X4000
	MOVW     R1,#0XC520
	STR      R1, [R0]
	MOVW     R1,#0XD928
	STR      R1, [R0]
	MOVW     R0,#0XA000   ; SWTO_CR (0X4000A000)
	MOVT     R0,#0X4000
	MOVW     R1,#0X0000
	MOVT     R1,#0XFF00
	STR      R1, [R0]

    MOVW     R0,#0X6010   ;SWT4_SR (0X40086010UL)
    MOVT     R0,#0X4008
	MOVW     R1,#0XC520   ;KEY
	STR      R1, [R0]
	MOVW     R1,#0XD928
	STR      R1, [R0]
	MOVW     R0,#0X6000   ;SWT4_CR (0X40086000UL)
	MOVT     R0,#0X4008
	MOVW     R1,#0X0000  ;SWT DISABLE
	MOVT     R1,#0XFF00
	STR      R1, [R0]

; ECC init of TCM data with use eDMA TCD0

    MOVW     R0,#0X3000   ; MM.L $40003000 $00000040
    MOVT     R0,#0X4000
	MOVW     R1,#0X0040
	MOVT     R1,#0X0000
	STR      R1, [R0]

    MOVW     R0,#0X3004   ; MM.L $40003004 $03030000
    MOVT     R0,#0X4000
	MOVW     R1,#0X0000
	MOVT     R1,#0X0303
	STR      R1, [R0]

    MOVW     R0,#0X3008   ; MM.L $40003008 $00400000
    MOVT     R0,#0X4000
	LDR      R1,=__TCM_DATA_SIZE__    
	STR      R1, [R0]

    MOVW     R0,#0X300C   ; MM.L $4000300C $00000000
    MOVT     R0,#0X4000
	MOVW     R1,#0X0000
	MOVT     R1,#0X0000
	STR      R1, [R0]

    MOVW     R0,#0X3010   ; MM.L $40003010 $3E800000
    MOVT     R0,#0X4000
	LDR      R1,=__TCM_DATA_START_ADDRESS__    
	STR      R1, [R0]

    MOVW     R0,#0X3014   ; MM.L $40003014 $00010008
    MOVT     R0,#0X4000
	MOVW     R1,#0X0008
	MOVT     R1,#0X0001
	STR      R1, [R0]

    MOVW     R0,#0X3018   ; MM.L $40003018 $00000000
    MOVT     R0,#0X4000
	MOVW     R1,#0X0000
	MOVT     R1,#0X0000
	STR      R1, [R0]

    MOVW     R0,#0X301C   ; MM.L $4000301C $00010089
    MOVT     R0,#0X4000
	MOVW     R1,#0X0001
	MOVT     R1,#0X0001
	STR      R1, [R0]

.sram_loop_tcm:
    MOVW     R0,#0X301C
    MOVT     R0,#0X4000
	LDR	R3, [R0]
	AND	R3, R3, #128
	CMP	R3, #128
	BNE	.sram_loop_tcm
    
#ifdef START_FROM_FLASH

; ECC init of SRAM with use eDMA TCD0

    MOVW     R0,#0X3000   ; MM.L $40003000 $00000040
    MOVT     R0,#0X4000
	MOVW     R1,#0X0040
	MOVT     R1,#0X0000
	STR      R1, [R0]

    MOVW     R0,#0X3004   ; MM.L $40003004 $03030000
    MOVT     R0,#0X4000
	MOVW     R1,#0X0000
	MOVT     R1,#0X0303
	STR      R1, [R0]

    MOVW     R0,#0X3008   ; MM.L $40003008 $00400000
    MOVT     R0,#0X4000
	LDR      R1,=__RAM_SIZE__    
	STR      R1, [R0]

    MOVW     R0,#0X300C   ; MM.L $4000300C $00000000
    MOVT     R0,#0X4000
	MOVW     R1,#0X0000
	MOVT     R1,#0X0000
	STR      R1, [R0]

    MOVW     R0,#0X3010   ; MM.L $40003010 $3E800000
    MOVT     R0,#0X4000
	LDR      R1,=__SRAM_START_ADDRESS__    
	STR      R1, [R0]

    MOVW     R0,#0X3014   ; MM.L $40003014 $00010008
    MOVT     R0,#0X4000
	MOVW     R1,#0X0008
	MOVT     R1,#0X0001
	STR      R1, [R0]

    MOVW     R0,#0X3018   ; MM.L $40003018 $00000000
    MOVT     R0,#0X4000
	MOVW     R1,#0X0000
	MOVT     R1,#0X0000
	STR      R1, [R0]

    MOVW     R0,#0X301C   ; MM.L $4000301C $00010089
    MOVT     R0,#0X4000
	MOVW     R1,#0X0001
	MOVT     R1,#0X0001
	STR      R1, [R0]

.sram_loop:
    MOVW     R0,#0X301C
    MOVT     R0,#0X4000
	LDR	R3, [R0]
	AND	R3, R3, #128
	CMP	R3, #128
	BNE	.sram_loop

#endif

        ;; Init .data and .bss sections
        LDR     R0, =init_data_bss
        BLX     R0
        CPSIE   I               ; Unmask interrupts

        #if defined (__ARMVFP__)  
            EXTERN init_FPU
            bl init_FPU
        #endif /* #if defined (__ARMVFP__) */  
        
        LDR     R0, =__iar_program_start
        BX      R0

        PUBWEAK NMI_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
NMI_Handler
        B .

        PUBWEAK HardFault_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
HardFault_Handler
        B .

        PUBWEAK MemManage_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
MemManage_Handler
        B .

        PUBWEAK BusFault_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
BusFault_Handler
        B .

        PUBWEAK UsageFault_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
UsageFault_Handler
        B .

        PUBWEAK SVC_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
SVC_Handler
        B .

        PUBWEAK DebugMon_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
DebugMon_Handler
        B .

        PUBWEAK PendSV_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
PendSV_Handler
        B .

        PUBWEAK SysTick_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
SysTick_Handler
        B .

        PUBWEAK DMA0_IRQHandler
        PUBWEAK DMA1_IRQHandler
        PUBWEAK DMA2_IRQHandler
        PUBWEAK DMA3_IRQHandler
        PUBWEAK DMA4_IRQHandler
        PUBWEAK DMA5_IRQHandler
        PUBWEAK DMA6_IRQHandler
        PUBWEAK DMA7_IRQHandler
        PUBWEAK DMA8_IRQHandler
        PUBWEAK DMA9_IRQHandler
        PUBWEAK DMA10_IRQHandler
        PUBWEAK DMA11_IRQHandler
        PUBWEAK DMA12_IRQHandler
        PUBWEAK DMA13_IRQHandler
        PUBWEAK DMA14_IRQHandler
        PUBWEAK DMA15_IRQHandler
        PUBWEAK DMA_Error_IRQHandler
        PUBWEAK MCM_IRQHandler
        PUBWEAK FTFE_IRQHandler
        PUBWEAK Read_Collision_IRQHandler
        PUBWEAK LVD_LVW_IRQHandler
        PUBWEAK FTFE_Fault_IRQHandler
        PUBWEAK Watchdog_IRQHandler
        PUBWEAK RCM_IRQHandler
        PUBWEAK LPI2C0_IRQHandler
        PUBWEAK LPI2C1_IRQHandler
        PUBWEAK LPSPI0_IRQHandler
        PUBWEAK LPSPI1_IRQHandler
        PUBWEAK LPSPI2_IRQHandler
        PUBWEAK Reserved45_IRQHandler
        PUBWEAK Reserved46_IRQHandler
        PUBWEAK LPUART0_RxTx_IRQHandler
        PUBWEAK Reserved48_IRQHandler
        PUBWEAK LPUART1_RxTx_IRQHandler
        PUBWEAK Reserved50_IRQHandler
        PUBWEAK LPUART2_RxTx_IRQHandler
        PUBWEAK Reserved52_IRQHandler
        PUBWEAK LPUART3_RxTx_IRQHandler
        PUBWEAK Reserved54_IRQHandler
        PUBWEAK ADC0_IRQHandler
        PUBWEAK CMP0_IRQHandler
        PUBWEAK Reserved57_IRQHandler
        PUBWEAK FTM0_IRQHandler
        PUBWEAK FTM1_IRQHandler
        PUBWEAK FTM2_IRQHandler
        PUBWEAK Reserved61_IRQHandler
        PUBWEAK RTC_IRQHandler
        PUBWEAK RTC_Seconds_IRQHandler
        PUBWEAK LPIT0_IRQHandler
        PUBWEAK Reserved65_IRQHandler
        PUBWEAK Reserved66_IRQHandler
        PUBWEAK Reserved67_IRQHandler
        PUBWEAK PDB0_IRQHandler
        PUBWEAK Reserved69_IRQHandler
        PUBWEAK Reserved70_IRQHandler
        PUBWEAK Reserved71_IRQHandler
        PUBWEAK Reserved72_IRQHandler
        PUBWEAK SCG_IRQHandler
        PUBWEAK LPTMR0_IRQHandler
        PUBWEAK PORTA_IRQHandler
        PUBWEAK PORTB_IRQHandler
        PUBWEAK PORTC_IRQHandler
        PUBWEAK PORTD_IRQHandler
        PUBWEAK PORTE_IRQHandler
        PUBWEAK SWI_IRQHandler
        PUBWEAK Reserved81_IRQHandler
        PUBWEAK Reserved82_IRQHandler
        PUBWEAK Reserved83_IRQHandler
        PUBWEAK PDB1_IRQHandler
        PUBWEAK FLEXIO_IRQHandler
        PUBWEAK Reserved86_IRQHandler
        PUBWEAK FTM3_IRQHandler
        PUBWEAK Reserved88_IRQHandler
        PUBWEAK ADC1_IRQHandler
        PUBWEAK Reserved90_IRQHandler
        PUBWEAK Reserved91_IRQHandler
        PUBWEAK Reserved92_IRQHandler
        PUBWEAK Reserved93_IRQHandler
        PUBWEAK CAN0_ORed_IRQHandler
        PUBWEAK CAN0_Error_IRQHandler
        PUBWEAK CAN0_Wake_Up_IRQHandler
        PUBWEAK CAN0_ORed_Message_buffer_IRQHandler
        PUBWEAK CAN0_Reserved1_IRQHandler
        PUBWEAK CAN0_Reserved2_IRQHandler
        PUBWEAK CAN0_Reserved3_IRQHandler
        PUBWEAK CAN1_ORed_IRQHandler
        PUBWEAK CAN1_Error_IRQHandler
        PUBWEAK CAN1_Wake_Up_IRQHandler
        PUBWEAK CAN1_ORed_Message_buffer_IRQHandler
        PUBWEAK CAN1_Reserved1_IRQHandler
        PUBWEAK CAN1_Reserved2_IRQHandler
        PUBWEAK CAN1_Reserved3_IRQHandler
        PUBWEAK CAN2_ORed_IRQHandler
        PUBWEAK CAN2_Error_IRQHandler
        PUBWEAK CAN2_Wake_Up_IRQHandler
        PUBWEAK CAN2_ORed_Message_buffer_IRQHandler
        PUBWEAK CAN2_Reserved1_IRQHandler
        PUBWEAK CAN2_Reserved2_IRQHandler
        PUBWEAK CAN2_Reserved3_IRQHandler
        PUBWEAK DefaultISR
        SECTION .text:CODE:REORDER:NOROOT(1)
DMA0_IRQHandler
DMA1_IRQHandler
DMA2_IRQHandler
DMA3_IRQHandler
DMA4_IRQHandler
DMA5_IRQHandler
DMA6_IRQHandler
DMA7_IRQHandler
DMA8_IRQHandler
DMA9_IRQHandler
DMA10_IRQHandler
DMA11_IRQHandler
DMA12_IRQHandler
DMA13_IRQHandler
DMA14_IRQHandler
DMA15_IRQHandler
DMA_Error_IRQHandler
MCM_IRQHandler
FTFE_IRQHandler
Read_Collision_IRQHandler
LVD_LVW_IRQHandler
FTFE_Fault_IRQHandler
Watchdog_IRQHandler
RCM_IRQHandler
LPI2C0_IRQHandler
LPI2C1_IRQHandler
LPSPI0_IRQHandler
LPSPI1_IRQHandler
LPSPI2_IRQHandler
Reserved45_IRQHandler
Reserved46_IRQHandler
LPUART0_RxTx_IRQHandler
Reserved48_IRQHandler
LPUART1_RxTx_IRQHandler
Reserved50_IRQHandler
LPUART2_RxTx_IRQHandler
Reserved52_IRQHandler
LPUART3_RxTx_IRQHandler
Reserved54_IRQHandler
ADC0_IRQHandler
CMP0_IRQHandler
Reserved57_IRQHandler
FTM0_IRQHandler
FTM1_IRQHandler
FTM2_IRQHandler
Reserved61_IRQHandler
RTC_IRQHandler
RTC_Seconds_IRQHandler
LPIT0_IRQHandler
Reserved65_IRQHandler
Reserved66_IRQHandler
Reserved67_IRQHandler
PDB0_IRQHandler
Reserved69_IRQHandler
Reserved70_IRQHandler
Reserved71_IRQHandler
Reserved72_IRQHandler
SCG_IRQHandler
LPTMR0_IRQHandler
PORTA_IRQHandler
PORTB_IRQHandler
PORTC_IRQHandler
PORTD_IRQHandler
PORTE_IRQHandler
SWI_IRQHandler
Reserved81_IRQHandler
Reserved82_IRQHandler
Reserved83_IRQHandler
PDB1_IRQHandler
FLEXIO_IRQHandler
Reserved86_IRQHandler
FTM3_IRQHandler
Reserved88_IRQHandler
ADC1_IRQHandler
Reserved90_IRQHandler
Reserved91_IRQHandler
Reserved92_IRQHandler
Reserved93_IRQHandler
CAN0_ORed_IRQHandler
CAN0_Error_IRQHandler
CAN0_Wake_Up_IRQHandler
CAN0_ORed_Message_buffer_IRQHandler
CAN0_Reserved1_IRQHandler
CAN0_Reserved2_IRQHandler
CAN0_Reserved3_IRQHandler
CAN1_ORed_IRQHandler
CAN1_Error_IRQHandler
CAN1_Wake_Up_IRQHandler
CAN1_ORed_Message_buffer_IRQHandler
CAN1_Reserved1_IRQHandler
CAN1_Reserved2_IRQHandler
CAN1_Reserved3_IRQHandler
CAN2_ORed_IRQHandler
CAN2_Error_IRQHandler
CAN2_Wake_Up_IRQHandler
CAN2_ORed_Message_buffer_IRQHandler
CAN2_Reserved1_IRQHandler
CAN2_Reserved2_IRQHandler
CAN2_Reserved3_IRQHandler
DefaultISR
        B DefaultISR

        END
