; ---------------------------------------------------------------------------------------
;  @file:    startup_S32V_M4.s
;  @purpose: S32V Core Device Startup File
;            Cortex-M4
; ---------------------------------------------------------------------------------------
;
; Copyright (c) 1997 - 2016 , Freescale Semiconductor, Inc.
; All rights reserved.
;
; Redistribution and use in source and binary forms, with or without modification,
; are permitted provided that the following conditions are met:
;
; o Redistributions of source code must retain the above copyright notice, this list
;   of conditions and the following disclaimer.
;
; o Redistributions in binary form must reproduce the above copyright notice, this
;   list of conditions and the following disclaimer in the documentation and/or
;   other materials provided with the distribution.
;
; o Neither the name of Freescale Semiconductor, Inc. nor the names of its
;   contributors may be used to endorse or promote products derived from this
;   software without specific prior written permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
; WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
; DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
; ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
; (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
; ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
; (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
; SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;*****************************************************************************
;* Version: GHS for ARM Embedded Processors                                  *
;*****************************************************************************
    .file "startup_S32V_M4.s"
    .text

    .need DefaultISR
    .globl DefaultISR

	.thumb

; Reset Handler
	.thumb
    .align 4
    .short 1
    .globl   Reset_Handler
     EXPORT Reset_Handler
    .weak    Reset_Handler
    .type    Reset_Handler, $function
    
Reset_Handler:
    cpsid   i               ; Mask interrupts

    ; Init the rest of the registers
    ldr     r1,=0
    ldr     r2,=0
    ldr     r3,=0
    ldr     r4,=0
    ldr     r5,=0
    ldr     r6,=0
    ldr     r7,=0
    mov     r8,r7
    mov     r9,r7
    mov     r10,r7
    mov     r11,r7
    mov     r12,r7

    ; Initialize the stack pointer
    ldr     r0,=__StackTop
    mov     r13,r0

; Disable Watchdog

    ldr     r0, =0x4000a010
	ldr     r1, =0xC520
	str      r1, [r0]
	ldr     r1, =0xD928
	str      r1, [r0]
	ldr     r0, =0x4000A000
	ldr     r1, =0xFF000000
	str      r1, [r0]

    ldr     r0, =0x40086010
    ldr     r1, =0xC520
	str      r1, [r0]
	ldr     r1, =0xD928
	str      r1, [r0]
	ldr     r0, =0x40086000
	ldr     r1, =0xFF000000
	str      r1, [r0]


; ECC init of TCM data with use eDMA TCD0

	; mm.l $40003000 $00000040
	ldr     r0, =0x40003000
	ldr     r1, =0x00000040
	str      r1, [r0]

   ; mm.l $40003004 $03030000
	ldr     r0, =0x40003004
	ldr     r1, =0x03030000
	str      r1, [r0]


   ; mm.l $40003008 $00400000
    ldr     r0, =0x40003008
	ldr     r1, =__TCM_DATA_SIZE__
	str      r1, [r0]


    ; mm.l $4000300C $00000000
    ldr     r0, =0x4000300C
	ldr     r1, =0x00000000
	str      r1, [r0]

   ; mm.l $40003010 $3e800000
    ldr     r0, =0x40003010
	ldr     r1, =__TCM_DATA_START_ADDRESS__
	str      r1, [r0]

    ; mm.l $40003014 $00010008
    ldr     r0, =0x40003014
	ldr     r1, =0x00010008
	str      r1, [r0]

    ; mm.l $40003018 $00000000
    ldr     r0, =0x40003018
	ldr     r1, =0x00000000
	str     r1, [r0]


    ; mm.l $4000301C $00010089
    ldr     r0, =0x4000301C
	ldr     r1, =0x00010089
	str      r1, [r0]

.sram_loop_tcm:
    ldr     r0, =0x4000301C

	ldr	r3, [r0]
	ldr	r0, =0x80
	and	r3, r0
	cmp	r3, #128
	bne	.sram_loop_tcm
    
#ifdef START_FROM_FLASH

; ECC init of SRAM with use eDMA TCD0

	; mm.l $40003000 $00000040
	ldr     r0, =0x40003000
	ldr     r1, =0x00000040
	str      r1, [r0]

   ; mm.l $40003004 $03030000
	ldr     r0, =0x40003004
	ldr     r1, =0x03030000
	str      r1, [r0]


   ; mm.l $40003008 $00400000
    ldr     r0, =0x40003008
	ldr     r1, =__RAM_SIZE__
	str      r1, [r0]


    ; mm.l $4000300C $00000000
    ldr     r0, =0x4000300C
	ldr     r1, =0x00000000
	str      r1, [r0]

   ; mm.l $40003010 $3e800000
    ldr     r0, =0x40003010
	ldr     r1, =__SRAM_START_ADDRESS__
	str      r1, [r0]

    ; mm.l $40003014 $00010008
    ldr     r0, =0x40003014
	ldr     r1, =0x00010008
	str      r1, [r0]

    ; mm.l $40003018 $00000000
    ldr     r0, =0x40003018
	ldr     r1, =0x00000000
	str     r1, [r0]


    ; mm.l $4000301C $00010089
    ldr     r0, =0x4000301C
	ldr     r1, =0x00010089
	str      r1, [r0]

.sram_loop:
    ldr     r0, =0x4000301C

	ldr	r3, [r0]
	ldr	r0, =0x80
	and	r3, r0
	cmp	r3, #128
	bne	.sram_loop

#endif

    ; Init .data and .bss sections
    ldr     r0,=init_data_bss
    blx     r0
    
#if defined (__FPU_USED)  
    bl init_FPU
#endif /* #if defined (__FPU_USED) */  

    bl    main
    .ltorg
    .size Reset_Handler, . - Reset_Handler

    .align	1
    .thumb
    .weak DefaultISR
    .type DefaultISR, $function
DefaultISR:
    b	DefaultISR
    .size DefaultISR, . - DefaultISR

    .end
