/*
 * flash_config.c
 *
 *  Created on: Nov 9, 2015
 *      Author: mgorshkova
 */

#if defined (__ICCARM__)
#pragma diag_suppress=Pe618
#endif

#include "S32V234.h"  /* include peripheral declarations */

#if defined (__ICCARM__)
#pragma diag_warning=Pe618
#endif


#define _RPC_MODE

#ifdef _RPC_MODE
#if defined (__ghs__)
#pragma ghs section rodata =".QSPIFlashConfig"
const uint8_t config_param[318] = {
#elif defined (__GNUC__)
const uint8_t __attribute__((section (".QSPIFlashConfig"))) config_param[318] = {
#elif defined (__ICCARM__)
#pragma location = "QSPIFlashConfig"
const uint8_t config_param[318] = {
#endif
0x01/*DQS Config : enable config*/,0x01/*DQS Config*/,0x01/*DQS Config*/,0x01/*DQS Config*/,0x01/*Hold Delay : Data aligned with 2x serial flash half clock*/,0x00/*Half Speed Phase Selection*/,0x00/*Half Speed Delay Selection*/,
0x00/*Reserved*/, 0x00/*Serial Clock Configuration*/,0x00/*Serial Clock Configuration*/,0x00/*Serial Clock Configuration*/,0x00/*Serial Clock Configuration*/,0x00/*SoC Configuration*/,0x00/*SoC Configuration*/,
0x00/*SoC Configuration*/,0x00/*SoC Configuration*/,0x00/*Reserved*/,0x00/*Reserved*/,0x00/*Reserved*/,0x00/*Reserved*/,0x00/*Chip Select hold time*/,0x00/*Chip Select hold time*/,0x00/*Chip Select hold time*/,
0x00/*Chip Select hold time*/,0x00/*Chip Select setup time*/,0x00/*Chip Select setup time*/,0x00/*Chip Select setup time*/,0x00/*Chip Select setup time*/,0x00/*Serial Flash A1 size*/,0x00/*Serial Flash A1 size*/,
0x00/*Serial Flash A1 size*/,0x40/*Serial Flash A1 size*/,0x00/*Serial Flash A2 size*/,0x00/*Serial Flash A2 size*/,0x00/*Serial Flash A2 size*/,0x00/*Serial Flash A2 size*/,0x00/*Serial Flash B1 size- IGNORED in RPC mode*/,
0x00/*Serial Flash B1 size*/,0x00/*Serial Flash B1 size*/,0x00/*Serial Flash B1 size*/,0x00/*Serial Flash B2 size*/,0x00/*Serial Flash B2 size*/,0x00/*Serial Flash B2 size*/,0x00/*Serial Flash B2 size*/,
0x03/*Serial Clock Frequency - 80 MHz*/,0x00/*Serial Clock Frequency*/,0x00/*Serial Clock Frequency*/,0x00/*Serial Clock Frequency*/,0x00/*Reserved*/,0x00/*Reserved*/,0x00/*Reserved*/,0x00/*Reserved*/,
0x00/*Mode of operation- IGNORED in RPC mode*/,0x00/*Serial Flash Port B Selection- IGNORED in RPC mode*/,0x01/*Dual Data Rate mode - Always enabled in RPC mode*/,0x01/*Data Strobe Signal - Always enabled in RPC mode*/,
0x00/*Parallel Mode enable - IGNORED in RPC mode*/,0x00/*CS1 on Port A*/,0x00/*CS1 on Port B*/,0x00/*Full Speed Phase Selection*/,0x00/*Full Speed Delay Selection*/,0x00/*DDR Sampling Point, No need because DQS enabled*/,
/*Flash specific LUT */0xA0,0x47,0x18,0x2B,0x10,0x4F,0x0F,0x0F,0x80,/* 128 bytes*/0x3B,0x00,0x03,/*STOP - 8pads*/0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#else

#if defined (__ghs__)
#pragma ghs section rodata =".QSPIFlashConfig"
const uint8_t config_param[318] = {
#elif defined (__GNUC__)
const uint8_t __attribute__((section (".QSPIFlashConfig"))) config_param[318] = {
#elif defined (__ICCARM__)
#pragma location = "QSPIFlashConfig"
const uint8_t config_param[318] = {
#endif
const uint8_t __attribute__((section (".QSPIFlashConfig"))) config_param[318] = {
0x00/*DQS Config*/,0x00/*DQS Config*/,0x00/*DQS Config*/,0x00/*DQS Config*/,0x00/*Hold Delay*/,0x00/*Half Speed Phase Selection*/,0x00/*Half Speed Delay Selection*/,0x00/*Reserved*/,
0x00/*Serial Clock Configuration*/,0x00/*Serial Clock Configuration*/,0x00/*Serial Clock Configuration*/,0x00/*Serial Clock Configuration*/,0x00/*SoC Configuration*/,0x00/*SoC Configuration*/,0x00/*SoC Configuration*/,
0x00/*SoC Configuration*/,0x00/*Reserved*/,0x00/*Reserved*/,0x00/*Reserved*/,0x00/*Reserved*/,0x00/*Chip Select hold time*/,0x00/*Chip Select hold time*/,0x00/*Chip Select hold time*/,0x00/*Chip Select hold time*/,
0x00/*Chip Select setup time*/,0x00/*Chip Select setup time*/,0x00/*Chip Select setup time*/,0x00/*Chip Select setup time*/,0x00/*Serial Flash A1 size*/,0x00/*Serial Flash A1 size*/,
0x80/*Serial Flash A1 size*/,0x00/*Serial Flash A1 size*/,0x00/*Serial Flash A2 size*/,0x00/*Serial Flash A2 size*/,0x80/*Serial Flash A2 size*/,0x00/*Serial Flash A2 size*/,
0x00/*Serial Flash B1 size*/,0x00/*Serial Flash B1 size*/,0x80/*Serial Flash B1 size*/,0x00/*Serial Flash B1 size*/,0x00/*Serial Flash B2 size*/,0x00/*Serial Flash B2 size*/,0x80/*Serial Flash B2 size*/,
0x00/*Serial Flash B2 size*/,0x00/*Serial Clock Frequency*/,0x00/*Serial Clock Frequency*/,0x00/*Serial Clock Frequency*/,0x00/*Serial Clock Frequency*/,0x00/*Reserved*/,0x00/*Reserved*/,
0x00/*Reserved*/,0x00/*Reserved*/,0x01/*Mode of operation*/,0x00/*Serial Flash Port B Selection*/,0x00/*Dual Data Rate mode*/,0x00/*Data Strobe Signal*/,0x00/*Parallel Mode enable*/,
0x01/*CS1 on Port A*/,0x01/*CS1 on Port B*/,0x00/*Full Speed Phase Selection*/,0x00/*Full Speed Delay Selection*/,0x00/*DDR Sampling Point*/,/*Flash specific LUT */0x03,0x04,0x18,0x08,0x08,0x1c,0x00,0x24,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#endif

#if defined (__ghs__)
#pragma ghs section rodata =default
#endif

extern void Reset_Handler(void);

#if defined (__ICCARM__)
#pragma location = "flash_boot_data"
#endif

struct BOOT_DATA_T {
    /* Start address of the image */
	const uint32_t start;
    /* Size of the image */
	const uint32_t size;
    /* Plugin Flag */
	const uint32_t plugin;
#if defined (__ghs__)
#pragma ghs section rodata =".flash_boot_data"
} const boot_data = {
#elif defined (__GNUC__)
} const __attribute__((section (".flash_boot_data")))  boot_data = {
#elif defined (__ICCARM__)
} const boot_data = {
#endif
	0x20000000,
    0x2000000,  /* 32 Mb */
    0x00000000
};

#define HAB_HDR(tag, len, par) {(tag),{(len)>>8, (len)}, (par)}
#define HAB_TAG_DCD  0xd2       /**< Device Configuration Data */
#define HAB_TAG_DCD_VER  0x50       /**< Device Configuration Data version*/
#define DCD_HEADER(x) HAB_HDR(HAB_TAG_DCD,sizeof(x)+sizeof(uint32_t),HAB_TAG_DCD_VER)
#define DCD_WRITE_PAR(bytes, mask,set)        (((bytes) & 0x7) | ((mask)<<3) | ((set)<<4))
#define cpu_be_16(x) ((((x)& 0xFF) << 8) | (((x) & 0xFF00) >> 8))
#define cpu_be_32(x)(((cpu_be_16((x)& 0xFFFF)) << 16) | (cpu_be_16((x) >>16)))
#define HAB_CMD_NOP 0xc0  /**< No Operation */
#define HAB_CMD_WRT_DAT 0xcc  /**< Write Data */
#define HAB_CMD_CHK_DAT 0xcf  /**< Check Data */

#if defined (__ICCARM__)
#pragma location = "flash_app_hdr"
#endif

struct  hab_ivt {
    /** @ref hdr with tag #HAB_TAG_IVT, length and HAB version fields
     * Tag Length Version
     * Tag: A single byte field set to 0xD1.
	   Length: a two byte field in big endian format containing the overall length of the IVT, in
				bytes, including the header. (The length is fixed and must have a value of 40 bytes)
	   Version: A single byte field set to 0x50
     *  (see @ref data)
     */
	const uint32_t hdr;
    /** Absolute address of the first instruction to execute from the
     *  image
     */
    #if defined (__ICCARM__)
    uint32_t entry;
    #else
	const void* entry;
    #endif
    /** Reserved in this version of HAB: should be NULL. */
    const void* reserved1;
    /** Absolute address of the image DCD: may be NULL. */
    const void* dcd;
    /** Absolute address of the Boot Data: may be NULL, but not interpreted
     *  any further by HAB
     */
    const void* boot_data;
    /** Absolute address of the IVT.*/
    const void* self;
    /** Absolute address of the image Secure Callback Image.*/
    const void* secure_callback;
    /** Absolute Address of Self Test Image. */
    const void* self_test;
    /** Authentication Length */
    const uint32_t auth_len;
    /** Reserved in this version of HAB: should be zero. */
    const uint32_t reserved2;

#if defined (__ghs__)
#pragma ghs section rodata =".flash_app_hdr"
} const start_app = {
#elif defined (__GNUC__)
} const __attribute__((section (".flash_app_hdr")))  start_app = {
#elif defined (__ICCARM__)
} const start_app = {
#endif

    0x502800d1 , /* hdr */
    #if defined (__ICCARM__)
	(uint32_t)&Reset_Handler, /* entry */
    #else
    &Reset_Handler, /* entry */
    #endif
    0x00000000, /* reserved1 */
    0x0, /* dcd */
    (const void*) 0x20001040, /* boot data */
    (const void*) 0x20001000, /* self */
    0x0, /*secure_callback*/
    0x0, /*self test*/
    0x0, /*auth len*/
    0x0, /*resv2*/
};

#if defined (__ghs__)
#pragma ghs section rodata =default
#endif

