/*
 * main implementation: use this 'C++' sample to create your own application
 *
 */

#include "S32V234.h" /* include peripheral declarations S32V234 */

/* Return value of MPIDR */
#define read_mpidr() ({									\
	unsigned long long __mpidr;							\
	__asm volatile("mrs %0, MPIDR_EL1" : "=r" (__mpidr));	\
	__mpidr;											\
})

#define get_clusterid(mpidr) ((mpidr >> 8) & 1)
#define get_coreid(mpidr) (mpidr & 1)

int clusterid, coreid, counter, accumulator = 0, limit_value = 1000000;

int main() {
	int mpidr = read_mpidr();
	clusterid = get_clusterid(mpidr);
	coreid = get_coreid(mpidr);
	counter = 0;

	for (;;) {
		counter++;

		if (counter >= limit_value) {
			/* Generates the supervisor call, the Current_EL3_SPx_Sync_Handler will be called to handle exception */
			__asm volatile ("svc 0");
			counter = 0;
		}
	}

	return 0;
}

/* User's part of Current_EL3_SPx_Sync_Handler defined in exception_handlers.S */
void Current_EL3_SPx_Sync() {
	accumulator += counter;
}
