  .arch	armv8-r
  .syntax unified
  $(INSTRUCTION_SET)

  .macro    ventry	label
  .align    1
  b    \label
  .endm

  .section .vectors
  .globl    __Vectors
__Vectors:

  .globl    __EL2_Vectors
  .align    5
__EL2_Vectors:
  ldr       pc, =EL2_Reset_Handler
  ventry    EL2_Undefined_Handler
  ventry    EL2_SVC_Handler
  ventry    EL2_Prefetch_Handler
  ventry    EL2_Abort_Handler
  ventry    EL2_Reserved_Handler
  ventry    EL2_IRQ_Handler
  ventry    EL2_FIQ_Handler

  .globl    __EL1_Vectors
  .align    5
__EL1_Vectors:
  ventry    EL1_Reset_Handler
  ventry    EL1_Undefined_Handler
  ventry    EL1_SVC_Handler
  ventry    EL1_Prefetch_Handler
  ventry    EL1_Abort_Handler
  ventry    EL1_Reserved_Handler
  ventry    EL1_IRQ_Handler
  ventry    EL1_FIQ_Handler

  .size    __Vectors, . - __Vectors

  .align    2
  .weak    Default_Handler
  .type    Default_Handler, %function
Default_Handler:
  b    .
  .pool
  .size    Default_Handler, . - Default_Handler

/*    Macro to define default handlers. Default handler
 *    will be weak symbol and just dead loops. They can be
 *    overwritten by other handlers */
  .macro    def_irq_handler handler_name
  .weak    \handler_name
  .set    \handler_name, Default_Handler
  .endm

  def_irq_handler    EL2_Reset_Handler
  def_irq_handler    EL2_Undefined_Handler
  def_irq_handler    EL2_SVC_Handler
  def_irq_handler    EL2_Prefetch_Handler
  def_irq_handler    EL2_Abort_Handler
  def_irq_handler    EL2_Reserved_Handler
  def_irq_handler    EL2_IRQ_Handler
  def_irq_handler    EL2_FIQ_Handler

  def_irq_handler    EL1_Reset_Handler
  def_irq_handler    EL1_Undefined_Handler
  def_irq_handler    EL1_SVC_Handler
  def_irq_handler    EL1_Prefetch_Handler
  def_irq_handler    EL1_Abort_Handler
  def_irq_handler    EL1_Reserved_Handler
  def_irq_handler    EL1_IRQ_Handler
  def_irq_handler    EL1_FIQ_Handler

  .end
