/* File: thumb_to_arm.S
 * Purpose: EL2 reset handler for switchig from Thumb mode to ARM mode.
 */
  .syntax unified
  .arch  armv8-r

  .text
  .thumb
  .globl EL2_Reset_Handler_Thumb
  .type  EL2_Reset_Handler_Thumb, %function

EL2_Reset_Handler_Thumb:
  eors   r0, r0, r0

  mrc    p15, 4, r0, c1, c0, 0    /* read HSCTLR */
  ldr    r1, =0xBFFFFFFF          /* Mask TE with 0 */
  ands   r0, r0, r1
  mcr    p15, 4, r0, c1, c0, 0    /*write HSCTLR */

  eors   r0, r0, r0

  mrc    p15, 0, r0, c1, c0, 0    /*read SCTLR */
  ldr    r1, =0xBFFFFFFF          /*Mask TE with 0 */
  ands   r0, r0, r1
  mcr    p15, 0, r0, c1, c0, 0    /* write SCTLR */

  ldr    r3, =EL2_Reset_Handler   /* prepare jump to real crt0 code and change to ARM mode */
  bx     r3

  .end
