#include <stdint.h>

/*----------------------------------------------------------------------------
  Linker generated Symbols
 *----------------------------------------------------------------------------*/
extern uint32_t __ecc_init_start__;
extern uint32_t __ecc_init_end__;

extern void SystemInit(void);
extern void SwitchEL2toEL1(void);

/*----------------------------------------------------------------------------
  User Initial Stack & Heap
 *----------------------------------------------------------------------------*/
#define  __STACK_SIZE  0x0001D000 /* Size is synchronized with with default newlib behavior */
static uint8_t stack[__STACK_SIZE] __attribute__ ((aligned(8), used, section(".stack")));

#define  __HEAP_SIZE   0x00003000  /* Size is synchronized with with default newlib behavior */
#if __HEAP_SIZE > 0
static uint8_t heap[__HEAP_SIZE]   __attribute__ ((aligned(8), used, section(".heap")));
#endif

/*----------------------------------------------------------------------------
  Reset Handler called on controller reset
 *----------------------------------------------------------------------------*/
void __attribute__((naked)) EL2_Reset_Handler(void) {
  register uint64_t *pDest64;

  /* .bss, heap and stack should have ECC initialization */
  for (pDest64 = (uint64_t*)&__ecc_init_start__; pDest64 < (uint64_t*)&__ecc_init_end__; pDest64++) {
    *pDest64 = 0xDEADBEEFFEEDCAFEUL;
  }

  SystemInit(); /* System Initialization */

  /* ARMv8-R cores are in EL2 (hypervisor mode) after reset, and we need
     to first descend to EL1 (supervisor mode) before the traditional SP
     setting code can be run */
  SwitchEL2toEL1();
  __builtin_unreachable(); /* No return here */
}
