/* File: mpu_init.S
 * Purpose: Provides MPU initalization
 */

  .arch armv8-r
  .syntax unified
  $(INSTRUCTION_SET)

  .global MpuInit

MpuInit:
  mov    r7, lr

  /* First region of memory is 0x00000000 to (0x40000000 - 1) this is code space */
  mov    r0, #0
  movw   r1, #0x0000
  movt   r1, #0x0000
  movw   r2, #0xFFFF
  movt   r2, #0x3FFF
  mov    r3, #1
  mov    r4, #0
  mov    r5, #7
  bl     Config_EL2_Gate_PT
  mov    r0,#0
  bl     EL2_Gate_Enable_PT

  /* Second region of memory is from 0x40000000 to 0xFFFFFFC0 this is peripheral space */
  mov    r0, #1
  movw   r1, #0x0000
  movt   r1, #0x4000
  movw   r2, #0xFFC0
  movt   r2, #0xFFFF
  mov    r3, #1
  mov    r4, #0
  mov    r5, #3
  bl     Config_EL2_Gate_PT
  mov    r0, #1
  bl     EL2_Gate_Enable_PT

  /* Same as above but for EL1 instead of EL2 */
  mov    r0, #0
  movw   r1, #0x0000
  movt   r1, #0x0000
  movw   r2, #0xFFFF
  movt   r2, #0x3FFF
  mov    r3, #1
  mov    r4, #0
  mov    r5, #7
  bl     Config_EL1_Gate_PT
  mov    r0, #0
  bl     EL1_Gate_Enable_PT
  mov    r0, #1
  movw   r1, #0x0000
  movt   r1, #0x4000
  movw   r2, #0xFFC0
  movt   r2, #0xFFFF
  mov    r3, #1
  mov    r4, #0
  mov    r5, #3
  bl     Config_EL1_Gate_PT
  mov    r0, #1
  bl     EL1_Gate_Enable_PT

  bl     Enable_EL2_MPU_PT
  bl     Enable_EL1_MPU_PT

  mov    lr, r7
  bx     lr


Config_EL2_Gate_PT: /* r0: gateNum, r1:start, r2:end, r3:access_per, r4:execute, r5:attr */
  mov    r9, r0
  mcr    p15, 4, R9, c6, c2, 1 /* Write HPRSELR */
  mrc    p15, 4, R9, c6, c3, 0 /* Read HPRBAR */
  and    r9, r9, #0xFFFFFFE7   /* Clear SH bits */
  and    r9, r9, #0xFFFFFFF9;  /* Clear permission bits */
  orr    r9, r9, r3, lsl #1    /* r9 |= (access_per<<1); */
  and    r9, r9, #0xFFFFFFFE   /* Clear XN bits */
  orr    r9, r9, r4            /* r9 |= execute; */
  lsr    r1, r1, 6             /* Clear bottom 6 bits. not sure how to do an and to clear it so I shifted down and back up */
  lsl    r1, r1, 6
  orr    r9, r9, r1            /* r9 |= start;	last 6 bits hardwired to zero */
  mcr    p15, 4, R9, c6, c3, 0 /* write HPRBAR */
  mrc    p15, 4, R9, c6, c3, 1 /* Read HPRLAR */
  and    r9, r9, #0xFFFFFFF1;  /* Clear attr bits */
  orr    r9, r9, r5, lsl #1    /* r9 |= (attr<<1); */
  lsr    r2, r2, 6             /* Clear bottom 6 bits. not sure how to do an and to clear it so I shifted down and back up */
  lsl    r2, r2, 6
  orr    r9, r9, r2            /* r9 |= end; +0x3F by default */
  mcr    p15, 4, R9, c6, c3, 1 /* Write HPRLAR */
  mov    pc, lr                /* Return with linker */


EL2_Gate_Enable_PT: /* r0 gate_number */
  mov    r9, r0                /* r9 = gate_number; select gate */
  mcr    p15, 4, R9, c6, c2, 1 /* Write HPRSELR */
  mrc    p15, 4, R9, c6, c3, 1 /* Read HPRLAR */
  orr    r9, r9, #1            /* r9 |= 1; */
  mcr    p15, 4, R9, c6, c3, 1 /* Write HPRLAR */
  mov    pc, lr                /* Return with linker */


Enable_EL2_MPU_PT:
  movw   r9, #0x8AA4            /* r9 = 0x00098AA4; */
  movt   r9, #0x0009
  mcr    p15, 4, R9, c10, c2, 0 /* Write HMAIR0 */
  movw   r9, #0x48E0            /* r9 = 0x44E048E0; */
  movt   r9, #0x44E0
  mcr    p15, 4, R9, c10, c2, 1 /* Write HMAIR1 */
  mrc    p15, 4, R9, c1, c0, 0  /* Read HSCTLR */
  orr    r9, r9, #1             /* Enable MPU for EL2 */
  mcr    p15, 4, R9, c1, c0, 0  /* Write HSCTLR */
  mov    pc, lr                 /* Return with linker */


Config_EL1_Gate_PT:/* r0: gateNum, r1:start, r2:end, r3:access_per, r4:execute, r5:attr */
  mov    r9, r0
  mcr    p15, 0, R9, c6, c2, 1  /* Write PRSELR */
  mrc    p15, 0, R9, c6, c3, 0  /* Read PRBAR */
  and    r9, r9, #0xFFFFFFE7    /* Clear SH bits */
  and    r9, r9, #0xFFFFFFF9;	/* Clear permission bits */
  orr    r9, r9, r3, lsl #1     /* r9 |= (access_per<<1); */
  and    r9, r9, #0xFFFFFFFE    /* Clear XN bits */
  orr    r9, r9, r4             /* r9 |= execute; */
  lsr    r1, r1, 6              /* Clear bottom 6 bits. not sure how to do an and to clear it so I shifted down and back up */
  lsl    r1, r1, 6
  orr    r9, r9, r1             /* r9 |= start; last 6 bits hardwired to zero */
  mcr    p15, 0, r9, c6, c3, 0  /* Write PRBAR */
  mrc    p15, 0, r9, c6, c3, 1  /* Read PRLAR */
  and    r9, r9, #0xFFFFFFF1;	/* Clear attr bits */
  orr    r9, r9, r5, lsl #1     /* r9 |= (attr<<1); */
  lsr    r2, r2, 6              /* Clear bottom 6 bits. not sure how to do an and to clear it so I shifted down and back up */
  lsl    r2, r2, 6
  orr    r9, r9, r2            /* R9 |= end;	// +0x3F by default */
  mcr    p15, 0, R9, c6, c3, 1 /* Write PRLAR */
  mov    pc, lr                /* Return with linker */


EL1_Gate_Enable_PT: /* r0 gate_number */
  mov    r9, r0                /* r9 = gate_number; select gate */
  mcr    p15, 0, r9, c6, c2, 1 /* Write PRSELR */
  mrc    p15, 0, r9, c6, c3, 1 /* Read PRLAR */
  orr    r9, r9, #1            /* REG9 |= 1; */
  mcr    p15, 0, r9, c6, c3, 1 /* Write PRLAR */
  mov    pc, lr                /* Return with linker */


Enable_EL1_MPU_PT:
  movw    r9, #0x8AA4	         /* r9 = 0x00098AA4; */
  movt    r9, #0x0009
  mcr     p15, 0, R0, c10, c2, 0 /* Write MAIR0 */
  movw    r9, #0x48E0            /* r9 = 0x44E048E0; */
  movt    r9, #0x44E0
  mcr     p15, 0, R0, c10, c2, 1 /* Write MAIR1 */

  mrc     p15, 0, R9, c1, c0, 0  /* Read SCTLR */
  orr     r9, r9, #1             /* enable MPU for EL1/0 */
  mcr     p15, 0, R9, c1, c0, 0  /* Write SCTLR */
  mov     pc, lr                 /* Return with linker */
