/*
 * main implementation: use this 'C' sample to create your own application
 *
 */

/* The register and bit field definitions for the S32S247TV */
#include "S32S247TV.h"

#ifdef SEMIHOSTING
#include <stdio.h>
#endif

#define read_mpidr() ({							\
	unsigned long long __mpidr;					\
	__asm volatile("mrc p15, 0, %0, c0, c0, 5"	\
		: "=r" (__mpidr)						\
		:										\
		: "cc");								\
	__mpidr;									\
})

#define clusterid(mpidr) ((mpidr >> 8) & 1)
#define coreid(mpidr) (mpidr & 1)

int clusterid, coreid, counter, accumulator = 0, limit_value = 1000000;

int main(void) {
	int mpidr = read_mpidr();
	clusterid = clusterid(mpidr);
	coreid = coreid(mpidr);

	counter = 0;

	for (;;) {
		counter++;

		if (counter >= limit_value) {
			__asm volatile ("svc 0");
			counter = 0;
		}
	}
	return 0;
}

void __attribute__ ((interrupt ("SWI"))) EL1_SVC_Handler() {
	accumulator += counter;
#ifdef SEMIHOSTING
	printf("cluster %d, R52 core %d, counter is 0x%08x, accumulator is 0x%08x\n",
			clusterid, coreid, counter, accumulator);
#endif
}
