/*******************************************************************************
 * Copyright (c) 2015 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.ui.v8.tracecommander.view;

import java.util.List;

import org.apache.log4j.Logger;

import com.freescale.sa.model.BoardType;
import com.freescale.sa.tracecommander.model.PlatformConfiguration;
import com.freescale.sa.tracecommander.model.TCGroup;
import com.freescale.sa.tracecommander.model.TCNode;
import com.freescale.sa.tracecommander.view.TraceCommanderView;
import com.freescale.sa.ui.v8.tracecommander.controller.ArmV8ConnectDisconnectTraceCollectionHandler;
import com.freescale.sa.ui.v8.tracecommander.controller.ArmV8HardwareConfigurator;
import com.freescale.sa.ui.v8.tracecommander.controller.ArmV8SaveTraceCollectionHandler;
import com.freescale.sa.ui.v8.tracecommander.controller.ArmV8TraceCommanderHandler;
import com.freescale.sa.ui.v8.tracecommander.controller.ArmV8TraceConfigurationHandler;

/**
 * The below class draws the Trace Commander View for ARMv8 based on the XML
 * platform configuration file
 * 
 * @author B44047
 * 
 */

public class ArmV8TraceCommanderView extends TraceCommanderView {

    private static Logger LOGGER = Logger.getLogger(ArmV8TraceCommanderView.class);

    /**
     * The constructor.
     */
    public ArmV8TraceCommanderView() {
        super();
    }

    @Override
    public List<String> getSupportedBoards() {
        List<String> boardsList = BoardType.getSupportedBoardsForCW("ARMv8");
        return boardsList;
    }

    @Override
    protected boolean handleNodeState(TCNode node) {
        return ArmV8TraceCommanderHandler.handleNodeAction(node);
    }

    @Override
    protected boolean handleGroupState(TCGroup nodesGroup) {
        return ArmV8TraceCommanderHandler.handleGroupAction(nodesGroup);
    }

    @Override
    protected void handleConfigAction(PlatformConfiguration platformCfg) {
        ArmV8TraceConfigurationHandler.handleConfigAction(platformCfg);
    }

    @Override
    protected void handleTraceConfigBlockAction(PlatformConfiguration platformCfg,
                                                String nodeName) {
        ArmV8TraceConfigurationHandler.handleTraceConfigBlockAction(platformCfg, nodeName);
    }

    @Override
    protected void handleNewPlatformConfig(String newName, String boardName) {
        ArmV8TraceConfigurationHandler.handleNewPlatformConfig(newName, boardName);
    }

    @Override
    protected void handleUploadAction(PlatformConfiguration platformCfg) {
        ArmV8SaveTraceCollectionHandler.handleSaveCommandOffline(platformCfg);
    }

    @Override
    protected boolean handleConnectAction(PlatformConfiguration platformCfg) {

        boolean statusOk = false;
        if (platformCfg == null) {
            LOGGER.error("[handleConnectAction] Null platform configuration."); //$NON-NLS-1$
            return statusOk;
        }

        if (!platformCfg.getConnected()) {
            statusOk = ArmV8ConnectDisconnectTraceCollectionHandler.connect(platformCfg);
            if (statusOk) {
                platformCfg.setConnected(true);
            }
        } else {
            ArmV8ConnectDisconnectTraceCollectionHandler.disconnect(platformCfg);
            platformCfg.setConnected(false);
        }

        return statusOk;
    }

    @Override
    protected boolean getTraceBufferMonitorStatus(PlatformConfiguration platformCfg) {
        boolean statusOK = false;
        if (platformCfg == null) {
            LOGGER.error("[getTraceBufferMonitorStatus] Null platform configuration."); //$NON-NLS-1$
            return statusOK;
        }
        ArmV8HardwareConfigurator hwConfig = ArmV8HardwareConfigurator.getInstance();
        if (hwConfig != null) {
            statusOK = hwConfig.getTraceBufferMonitorStatus();
        }
        return statusOK;
    }

    @Override
    protected int getBufferFillLevel(PlatformConfiguration platformCfg) {

        int fillLevel = 0;
        if (platformCfg == null) {
            LOGGER.error("[getBufferFillLevel] Null platform configuration."); //$NON-NLS-1$
            return fillLevel;
        }

        if (platformCfg.getConnected()) {
            fillLevel = ArmV8ConnectDisconnectTraceCollectionHandler.getBufferFillLevel(platformCfg);
        }
        return fillLevel;
    }
}