/*******************************************************************************
 * Copyright (c) 2015 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/

package com.freescale.sa.ui.v8.tracecommander.view;

import java.io.File;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

import com.freescale.sa.configurator.config.IAnalysisConfigurationContents;
import com.freescale.sa.configurator.ls.jni.LSConfigLoader_JNI;
import com.freescale.sa.ls.v8.launch.ui.LsV8ConfigurationContents;
import com.freescale.sa.tracecommander.view.SAConfigDialog;

/**
 * A profiles dialog allows the user to create, delete, duplicate, and in
 * general manage profiles.
 * 
 * The profile dialog is modeled after the launch configuration dialog, however,
 * it is associated with one configuration provider only (whereas the launch
 * configuration dialog displays all launch configurations for all launch
 * configuration types)
 * 
 * It displays the profiles with its configurations as children in the tree
 * viewer in the left pane, and displays the configuration elements of the
 * selection in the tree in the right pane.
 */

public class ArmV8ConfigDialog extends SAConfigDialog {

	private static Logger LOGGER = Logger.getLogger(ArmV8ConfigDialog.class);

	private IAnalysisConfigurationContents saContents;

	/**
	 * Constructor
	 * 
	 * @param parent
	 *            - the parent shell
	 * @param path
	 *            - the path to the node (page) to display when the dialog comes
	 *            up. The path is delimited by the character '/' May be null, in
	 *            which case either a previous selection, if one exists, is
	 *            displayed or the first node.
	 */
	public ArmV8ConfigDialog(Shell parent, ILaunchConfiguration config,
			File platformConfig) throws Exception {
		super(parent, config, platformConfig);
	}

	@Override
	protected Control createDialogArea(Composite parent) {

		Composite comp = (Composite) (super.createDialogArea(parent));
		saContents = new LsV8ConfigurationContents();
		if (saContents instanceof LsV8ConfigurationContents) {
			saContents.setParent(comp);
			saContents.createConfigControls(comp);
			saContents.initializeFrom(platformConfig);

		}
		return comp;
	}

	@Override
	protected void buttonPressed(int buttonId) {
		if (IDialogConstants.OK_ID == buttonId && saContents != null) {
			try {
				if (config != null) {
					ILaunchConfigurationWorkingCopy copy = config
							.getWorkingCopy();
					saContents.updateConfig(copy);
					saContents.performApply(copy);
					copy.doSave();
				}

				((LsV8ConfigurationContents) saContents).saveConfiguration();

				LSConfigLoader_JNI configLoader = new LSConfigLoader_JNI(
						platformConfig.getPath());
				configLoader.saveConfigToXml();

				okPressed();
			} catch (CoreException e) {
				LOGGER.error("[buttonPressed]: ", e);
			}
		} else if (IDialogConstants.CANCEL_ID == buttonId) {
			cancelPressed();
		}
	}

	@Override
	protected boolean isResizable() {
		return false;
	}

	@Override
	protected Point getInitialSize() {
		return new Point(350, 570);
	}

}
