/*******************************************************************************
 * Copyright (c) 2016-2018 NXP
 *
 * Copyright (c) 2016 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/

package com.freescale.sa.ui.v8.tracecommander.utils;

import com.freescale.sa.ls.v8.launch.ui.LsV8LaunchUtils;

public class TraceCommanderUtils {
    /**
     * Checks if debugger is in U-Boot stage 3 (the U-Boot code is already
     * relocated in RAM)
     *
     * @return false if U-Boot runs from flash, true if the U-Boot code is
     *         already in RAM
     */
    public static boolean isUBootRelocated() {

        if (LsV8LaunchUtils.NOT_AVAILABLE.equals(LsV8LaunchUtils.getUbootRelocationAddress())) {
            return false;
        }

        return true;
    }
}
