/*******************************************************************************
 * Copyright (c) 2014-2016: Freescale Semiconductor, Inc. All Rights Reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.ui.v8.tracecommander.controller;

import org.apache.log4j.Logger;
import org.eclipse.debug.core.ILaunch;

import com.freescale.sa.configurator.ls.jni.JniConfigurationUtils;
import com.freescale.sa.configurator.ls.jni.LSConfigLoader_JNI;
import com.freescale.sa.ls.v8.applyconfig.jni.LSV8JNIConfigurationConstants;
import com.freescale.sa.trace.configandcollect.TraceStreamManager;
import com.freescale.sa.trace.configandcollect.model.ITraceStream;
import com.freescale.sa.tracecommander.UIConstants.NodeType;
import com.freescale.sa.tracecommander.model.TCGroup;
import com.freescale.sa.tracecommander.model.TCNode;
import com.freescale.sa.util.AttrNotFoundException;
import com.freescale.sa.util.CommonConstants;
import com.freescale.sa.util.LaunchConfigUtils;

public class ArmV8TraceCommanderHandler {

    private static Logger LOGGER = Logger.getLogger(ArmV8TraceCommanderHandler.class);

    /**
     * Handles the start-stop of a trace generator group
     */
    public static boolean handleGroupState(TCGroup nodesGroup) {
        if (nodesGroup == null) {
            LOGGER.error("Trace generator group is null."); //$NON-NLS-1$
            return false;
        }
        boolean statusOK = false;
        if (nodesGroup.getGroupState()) {
            for (TCNode node : nodesGroup.getTCNodeCollection()) {
                statusOK = executeStartStop(node, !nodesGroup.getGroupState());
                if (!statusOK) {
                    return statusOK;
                }
                node.setNodeState(false);
            }
            nodesGroup.setGroupState(false);
        } else {
            for (TCNode node : nodesGroup.getTCNodeCollection()) {
                statusOK = executeStartStop(node, !nodesGroup.getGroupState());
                if (!statusOK) {
                    return statusOK;
                }
                node.setNodeState(true);
            }
            nodesGroup.setGroupState(true);
        }

        return statusOK;
    }

    /**
     * Handles the start-stop of a trace generator node
     */
    public static boolean handleNodeState(TCNode node) {
        if (node == null) {
            LOGGER.error("Trace generator is null."); //$NON-NLS-1$
        }
        boolean statusOk = true;

        if (node.getNodeType().equals(NodeType.DTS.toString())) {
            statusOk = changeDataStream(node);
        } else {
            statusOk = executeStartStop(node, !node.getNodeState());
            if (statusOk) {
                if (node.getNodeState()) {
                    node.setNodeState(false);
                } else {
                    node.setNodeState(true);
                }
            }
        }

        return statusOk;
    }

    private static boolean changeDataStream(TCNode node) {
        if (node == null) {
            LOGGER.error("No data stream has been selected."); //$NON-NLS-1$
            return false;
        }
        return ArmV8StartStopTraceCollectionHandler.changeDataStream(node);
    }

    private static boolean executeStartStop(TCNode node, boolean newState) {
        if (node == null) {
            LOGGER.error("No trace generator has been selected."); //$NON-NLS-1$
            return false;
        }

        LSConfigLoader_JNI m_configLoader = new LSConfigLoader_JNI(node.getFile().getPath());
        String launchConfigName = null;
        try {
            launchConfigName = JniConfigurationUtils.getStringAttrValue(m_configLoader,
                                                                        CommonConstants.PLATFORM_CONFIG_ACTIVE_LAUNCH_CFG_ATTR);
        } catch (AttrNotFoundException e) {
            LOGGER.error("Error at reading launch configuration name attribute.", e); //$NON-NLS-1$
        }

        ILaunch launch = LaunchConfigUtils.getLaunch(launchConfigName);
        ITraceStream stream = null;
        if (launch != null) {
            stream = TraceStreamManager.getDefault().getTraceStream(launch);
        }

        String targetAcces = null;
        try {
            targetAcces = JniConfigurationUtils.getStringAttrValue(m_configLoader,
                                                                   CommonConstants.PLATFORM_CONFIG_ACTIVE_TARGET_ACCESS_METHOD_ATTR);
        } catch (AttrNotFoundException e) {
            LOGGER.error("Error at reading target access method name attribute.", e); //$NON-NLS-1$
        }

        if (!((targetAcces != null) && (targetAcces.equals(LSV8JNIConfigurationConstants.TARGET_ACCESS_GTA))
              && (launch != null))) {

            return ArmV8StartStopTraceCollectionHandler.handleStartStopCommandOffline(stream, node,
                                                                                      newState);
        }

        return false;
    }

    public static boolean handleNodeAction(TCNode node) {
        return handleNodeState(node);
    }

    public static boolean handleGroupAction(TCGroup nodesGroup) {
        return handleGroupState(nodesGroup);
    }

}
