/*******************************************************************************
 * Copyright (c) 2014-2016 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.ui.v8.tracecommander.controller;

import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

import com.freescale.sa.Messages;
import com.freescale.sa.configurator.ls.jni.JniConfigurationUtils;
import com.freescale.sa.configurator.ls.jni.LSConfigLoader_JNI;
import com.freescale.sa.trace.configandcollect.model.ITraceStream;
import com.freescale.sa.tracecommander.TCUtils;
import com.freescale.sa.tracecommander.UIConstants.NodeType;
import com.freescale.sa.tracecommander.controller.StartStopTraceCollectionHandler;
import com.freescale.sa.tracecommander.model.TCNode;
import com.freescale.sa.util.AttrNotFoundException;
import com.freescale.sa.util.CommonConstants;

/**
 * 
 * Starts trace collection for the trace stream associated with the currently
 * selected debug target.
 */
public class ArmV8StartStopTraceCollectionHandler extends StartStopTraceCollectionHandler {

    private static Logger LOGGER = Logger.getLogger(ArmV8StartStopTraceCollectionHandler.class);

    static boolean execute(TCNode traceGenNode, boolean newState, boolean force) {
        if (traceGenNode == null) {
            LOGGER.error("[execute] Trace generator is invalid!"); //$NON-NLS-1$
            return false;
        }

        boolean statusOk = true;
        ArmV8HardwareConfigurator hwConfig = ArmV8HardwareConfigurator.getInstance();

        // for NOC we need to add the type for the configurator to know which
        // trace generator to configure
        String traceGenName = traceGenNode.getNodeName();
        if (traceGenNode.getNodeType().toString().equals(CommonConstants.NOC_MAIN_TRACE_GEN_NAME)) {
            traceGenName = Messages.NOCMainName + ":" + traceGenName; //$NON-NLS-1$
        } else if (traceGenNode.getNodeType().toString()
                               .equals(CommonConstants.NOC_HSIO_TRACE_GEN_NAME)) {
            traceGenName = Messages.NOCHsioName + ":" + traceGenName; //$NON-NLS-1$
        }

        statusOk = hwConfig.controlSource(traceGenName, newState, force);

        return statusOk;
    }

    public static boolean changeState(TCNode node, boolean newState) {
        if (node == null) {
            return false;
        }
        if (node.getFile() == null) {
            return false;
        }
        LSConfigLoader_JNI m_configLoader = new LSConfigLoader_JNI(node.getFile().getPath());
        try {
            JniConfigurationUtils.setBoolAttrValue(m_configLoader,
                                                   String.format(CommonConstants.PLATFORM_CONFIG_TRACE_ENABLE_ATTR,
                                                                 TCUtils.convertTraceGeneratorNameToString(node.getNodeType()
                                                                                                               .toString()),
                                                                 node.getNodeName()),
                                                   newState);
            m_configLoader.saveConfigToXml();
        } catch (AttrNotFoundException e) {
            LOGGER.error("Error at writing trace generator status attribute.", e); //$NON-NLS-1$
            return false;
        }

        return true;
    }

    public static boolean changeDataStream(TCNode node) {
        if (node == null) {
            return false;
        }
        if (!node.getNodeType().equals(NodeType.DTS.toString())) {
            return false;
        }
        if (node.getFile() == null) {
            return false;
        }

        LSConfigLoader_JNI m_configLoader = new LSConfigLoader_JNI(node.getFile().getPath());
        if (!node.getNodeState()) {
            try {
                JniConfigurationUtils.setEnumAttrValue(m_configLoader,
                                                       CommonConstants.PLATFORM_CONFIG_TRACE_LOCATION,
                                                       node.getNodeName());
                m_configLoader.saveConfigToXml();
            } catch (AttrNotFoundException e) {
                LOGGER.error("Error at writing trace location attribute for data stream.", e); //$NON-NLS-1$
                return false;
            }
        }
        return true;
    }

    public static boolean handleStartStopCommandOffline(final ITraceStream stream, TCNode node,
                                                        boolean newState) {

        boolean statusOk = true;
        // write registers
        statusOk = execute(node, newState, false);
        if (statusOk) {
            // changes values in platform configuration file
            statusOk = changeState(node, newState);
            return statusOk;
        } else {
            LOGGER.error("[handleSaveCommandOffline]: Failed to create a connection!"); //$NON-NLS-1$
            MessageDialog.openWarning(Display.getDefault().getActiveShell(),
                                      com.freescale.sa.tracecommander.Messages.TraceCommander_Connect_Warning_Title,
                                      com.freescale.sa.tracecommander.Messages.TraceCommander_Terminate_Warning_Message);
            return false;
        }
    }
}
