/*******************************************************************************
 * Copyright (c) 2018 NXP. All rights reserved.
 * NXP Internal Only. Not for distribution
 *******************************************************************************/
/*******************************************************************************
 * Copyright (c) 2014-2016 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.ui.v8.tracecommander.controller;

import java.io.File;
import java.util.Random;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

import com.freescale.sa.configurator.ls.jni.JniConfigurationUtils;
import com.freescale.sa.configurator.ls.jni.LSConfigLoader_JNI;
import com.freescale.sa.ls.v8.launch.trace_stream.LsV8TraceStream;
import com.freescale.sa.ls.v8.launch.trace_stream.TCCContext;
import com.freescale.sa.trace.configandcollect.TraceStreamManager;
import com.freescale.sa.trace.configandcollect.model.ITraceStream;
import com.freescale.sa.tracecommander.Messages;
import com.freescale.sa.tracecommander.model.PlatformConfiguration;
import com.freescale.sa.tracecommander.model.TCGroup;
import com.freescale.sa.tracecommander.model.TCNode;
import com.freescale.sa.util.AttrNotFoundException;
import com.freescale.sa.util.CommonConstants;
import com.freescale.sa.util.Utils;

/**
 * Saves collected trace to a file for the trace stream associated with the
 * currently selected debug target.
 * 
 */
public class ArmV8SaveTraceCollectionHandler {

    static final protected Logger LOGGER = Logger.getLogger(ArmV8SaveTraceCollectionHandler.class);
    private static final String SAMPLE_DATA_TRACE_LOCATION = "/data/fsl.sample.trace/layerscape_2"; //$NON-NLS-1$
    private static final String SAMPLE_DATA_TRACE_FILE = "ddr_64kb_atb.dat"; //$NON-NLS-1$
    private static final String ANALYSIS_RESULTS_LOCATION = "/.AnalysisResults"; //$NON-NLS-1$
    private static final String DATA_TRACE_FILE_EXTENSION = ".dat"; //$NON-NLS-1$
    private static String dataTraceLocationPath = null;

    public static void handleSaveCommandOnline(ILaunch launch) {
        ITraceStream stream = TraceStreamManager.getDefault().getTraceStream(launch);
        if (stream instanceof LsV8TraceStream) {
            LsV8TraceStream v8_Stream = (LsV8TraceStream) stream;
            v8_Stream.collectOnDemand();
        }
    }

    public static void handleSaveCommandOffline(PlatformConfiguration platfCfgNode) {

        if (platfCfgNode == null) {
            LOGGER.error("[handleSaveCommandOffline]: Null platfrom configuration!"); //$NON-NLS-1$
        }

        TCCContext context = new TCCContext(platfCfgNode.getPlatCfgFile());

        // Disable all trace generators
        if ((platfCfgNode.getTraceGeneratorNode() != null)
            && (platfCfgNode.getTraceGeneratorNode().getTCGroupCollection() != null)) {
            for (TCGroup group : platfCfgNode.getTraceGeneratorNode().getTCGroupCollection()) {
                for (TCNode node : group.getTCNodeCollection()) {
                    if (node.getNodeState()) { // if a node (trace generator) is
                                               // started
                        boolean statusOK = ArmV8StartStopTraceCollectionHandler.execute(node,
                                                                                        false, true);
                        if (!statusOK) {
                            LOGGER.error("[handleSaveCommandOffline]: Failed to create a connection!"); //$NON-NLS-1$
                            MessageDialog.openWarning(Display.getDefault().getActiveShell(),
                                                      Messages.TraceCommander_Connect_Warning_Title,
                                                      Messages.TraceCommander_Terminate_Warning_Message);
                            return;
                        }
                    }
                }
            }
        }

        // Collect trace
        LsV8TraceStream.collectTrace(context);
    }

    public static void saveDataTrace(PlatformConfiguration platfCfgNode) {
        setDataTraceLocationPath(platfCfgNode);
        if (dataTraceLocationPath == null) {
            LOGGER.error("[handleSaveCommandOffline]: Unable to set data trace output folder!"); //$NON-NLS-1$
        }
        File sourceDataTrace = getDefaultSampleDataTraceFile();
        String newDataTraceFileName = dataTraceLocationPath + File.separator
                                      + platfCfgNode.getPlatCfgFileName()
                                      + DATA_TRACE_FILE_EXTENSION;
        File destDataTrace = new File(newDataTraceFileName);
        Random randomGenerator = new Random();
        if (destDataTrace.exists()) {
            Utils.copyFolder(sourceDataTrace,
                             new File(dataTraceLocationPath + File.separator
                                      + platfCfgNode.getPlatCfgFileName() + "_"
                                      + randomGenerator.nextInt(100) + DATA_TRACE_FILE_EXTENSION));
        } else {
            Utils.copyFolder(sourceDataTrace, destDataTrace);
        }
    }

    public static void setDataTraceLocationPath(PlatformConfiguration platfCfgNode) {
        if (platfCfgNode == null) {
            dataTraceLocationPath = "";
            LOGGER.error("[setDataTraceLocationPath]: No platform config node selected."); //$NON-NLS-1$
            return;
        }
        File platfCfgFile = platfCfgNode.getPlatCfgFile();
        if (platfCfgFile == null) {
            dataTraceLocationPath = "";
            LOGGER.error("[setDataTraceLocationPath]: No platform config file defined."); //$NON-NLS-1$
            return;
        }
        String platformConfigName = platfCfgFile.getAbsolutePath();
        LSConfigLoader_JNI m_configLoader = new LSConfigLoader_JNI(platformConfigName);
        try {
            dataTraceLocationPath = JniConfigurationUtils.getStringAttrValue(m_configLoader,
                                                                             CommonConstants.RESULTS_OUTPUT_FOLDER_ATTR);

            if (dataTraceLocationPath.equals("")) { //$NON-NLS-1$
                dataTraceLocationPath = ResourcesPlugin.getWorkspace().getRoot().getLocation()
                                                       .toString()
                                                       .concat(ANALYSIS_RESULTS_LOCATION);
            }
        } catch (AttrNotFoundException e) {
            if (dataTraceLocationPath == null) { // $NON-NLS-1$
                dataTraceLocationPath = ResourcesPlugin.getWorkspace().getRoot().getLocation()
                                                       .toString()
                                                       .concat(ANALYSIS_RESULTS_LOCATION);
                return;
            } else {

                LOGGER.error("[setDataTraceLocationPath]: Unable to set data trace output folder!", //$NON-NLS-1$
                             e);
            }
        }
    }

    /**
     * Get default file for sample data trace on ARMv8
     * ('\data\fsl.sample.trace\layerscape_2\ddr_64kb_atb.dat').
     * 
     * @return the default storage path to the sample data trace files for ARMv8
     */
    public static File getDefaultSampleDataTraceFile() {

        // Load the sample data trace
        String sampleDataTraceFile = Utils.getCWSAHome() + SAMPLE_DATA_TRACE_LOCATION
                                     + File.separator + SAMPLE_DATA_TRACE_FILE;

        return new File(sampleDataTraceFile);
    }
}
