/*******************************************************************************
 * Copyright (c) 2015 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/

package com.freescale.sa.ls.traceviewer.okra;

import java.io.IOException;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

import com.freescale.sa.ui.common.StreamMonitor;
import com.freescale.sa.ui.common.StreamMonitor.Type;

/**
 * Progress monitor for command line OKRA decoders
 * 
 * @author B46903
 * 
 */
public class OkraProgressMonitor implements IRunnableWithProgress {
	private static Logger LOGGER = Logger.getLogger(OkraProgressMonitor.class);

	private String[] execArgs;
	private boolean errors = false;
	private boolean canceled = false;
	private String taskName;

	public OkraProgressMonitor(String[] execArgs, String taskName) {
		this.execArgs = execArgs.clone();
		this.taskName = taskName;
	}

	public boolean hasErrors() {
		return errors;
	}

	public boolean isCanceled() {
		return canceled;
	}

	@Override
	public void run(IProgressMonitor monitor) {
		Process p = null;
		try {
			p = Runtime.getRuntime().exec(execArgs);
		} catch (IOException e) {
			LOGGER.error("Error while decoding hardware trace ", e); //$NON-NLS-1$
			errors = true;
		}

		monitor.beginTask(taskName, 100);

		// any error message?
		if (p != null) {
			StreamMonitor errorMonitor = new StreamMonitor(p.getErrorStream(),
					Type.ERROR, monitor, p);

			// any output?
			StreamMonitor outputMonitor = new StreamMonitor(p.getInputStream(),
					Type.OUTPUT, null, null);
			errorMonitor.start();
			outputMonitor.start();

			int exitCode = -1;
			boolean stillRunning;
			while (true) {
				stillRunning = false;

				try {
					exitCode = p.exitValue();
				} catch (IllegalThreadStateException ex) {
					stillRunning = true;
					// User pressed "Cancel" button
					if (monitor.isCanceled()) {
						p.destroy();
						canceled = true;
						break;
					}
					try {
						Thread.sleep(500);
					} catch (InterruptedException e) {
					}
				}

				if (!stillRunning) {
					break;
				}
			}

			if (exitCode != 0) {
				errors = true;
			}

		}
	}

}
