/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/

package com.freescale.sa.ls.traceviewer.editors;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

/**
 * Class implementing command for CollapseAll tree functionality
 * @author R70188
 *
 */
public class TreeViewCommand implements ILayerCommand {
	
	/**
	 * Enumeration with all commands handled by the Tree Layer
	 */
	public enum TreeCommand {
		COLLAPSE_ALL,
		EXPAND_ALL
	}
	
	private TreeCommand m_treeCommand;
	
	public TreeViewCommand(TreeCommand command) {
		super();
		m_treeCommand = command;
	}
	
	public TreeViewCommand(TreeViewCommand treeViewCommand) {
		super();
		m_treeCommand = treeViewCommand.m_treeCommand;
	}
	
	public TreeCommand getCommand() {
		return m_treeCommand;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.nebula.widgets.nattable.command.ILayerCommand#convertToTargetLayer(org.eclipse.nebula.widgets.nattable.layer.ILayer)
	 */
	@Override
	public boolean convertToTargetLayer(ILayer targetLayer) {
		return true;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.nebula.widgets.nattable.command.ILayerCommand#cloneCommand()
	 */
	@Override
	public ILayerCommand cloneCommand() {
		return new TreeViewCommand(this);
	}

}
