/*******************************************************************************
 * Copyright 2016-2018 NXP
 *
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/

package com.freescale.sa.ls.traceviewer.editors;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.event.HideRowPositionsEvent;
import org.eclipse.nebula.widgets.nattable.hideshow.event.ShowRowPositionsEvent;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.TreeLayer;

import com.freescale.sa.ls.traceviewer.editors.TreeViewCommand.TreeCommand;

/**
 * Tree Layer extension for handling collapse and expand all commands
 * 
 * @author R70188
 * 
 */
public class TraceViewerTreeLayer extends TreeLayer {

	/**
	 * Constructor
	 * 
	 * @param underlyingLayer
	 * @param treeRowModel
	 * @param useDefaultConfiguration
	 */
	public TraceViewerTreeLayer(IUniqueIndexLayer underlyingLayer,
			ITreeRowModel<?> treeRowModel, boolean useDefaultConfiguration) {
		super(underlyingLayer, treeRowModel, useDefaultConfiguration);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.nebula.widgets.nattable.tree.TreeLayer#doCommand(org.eclipse
	 * .nebula.widgets.nattable.command.ILayerCommand)
	 */
	@Override
	public boolean doCommand(ILayerCommand command) {
		if (command instanceof TreeViewCommand
				&& command.convertToTargetLayer(this)) {
			TreeViewCommand treeCommand = (TreeViewCommand) command;
			TreeCommand com = treeCommand.getCommand();
			if (com == TreeCommand.COLLAPSE_ALL) {
				collapseAll();
				return true;
			} else if (com == TreeCommand.EXPAND_ALL) {
				expandAll();
				return true;
			} else {
				return false;
			}
		} else {
			return super.doCommand(command);
		}
	}

	/**
	 * Collapses all the tree nodes
	 */
	@Override
	public void collapseAll() {

		List<Integer> rowIndexes = new ArrayList<Integer>();
		for (int i = 0; i < this.getUnderlyingLayer().getRowCount(); i++) {
			if (this.getModel().hasChildren(i)
					&& !this.getModel().isCollapsed(i)) {
				rowIndexes.addAll(this.getModel().collapse(i));
			}
		}
		this.getHiddenRowIndexes().addAll(rowIndexes);
		invalidateCache();
		fireLayerEvent(new HideRowPositionsEvent(this, null));
	}

	/**
	 * Expands all the tree nodes
	 */
	@Override
	public void expandAll() {

		List<Integer> rowIndexes = new ArrayList<Integer>();
		for (int i = 0; i < this.getUnderlyingLayer().getRowCount(); i++) {
			if (this.getModel().hasChildren(i)
					&& this.getModel().isCollapsed(i)) {
				rowIndexes.addAll(this.getModel().expand(i));
			}
		}
		this.getHiddenRowIndexes().clear();
		invalidateCache();
		fireLayerEvent(new ShowRowPositionsEvent(this, null));
	}

}
