/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/

package com.freescale.sa.ls.traceviewer.editors;

import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

/**
 * Class that defines custom cell styles
 * @author R70188
 *
 */
public class TraceViewerRegistryConfiguration extends
		AbstractRegistryConfiguration {
	
	public static final Color INFO_BACKGROUND_COLOR = new Color(Display.getCurrent(), new RGB(51, 204, 255));
	public static final Color ERROR_BACKGROUND_COLOR = new Color(Display.getCurrent(), new RGB(255, 51, 102));
	public static final Color BRANCH_BACKGROUND_COLOR = new Color(Display.getCurrent(), new RGB(51, 255, 102));
	public static final Color CUSTOM_BACKGROUND_COLOR = new Color(Display.getCurrent(), new RGB(255, 204, 51));
	public static final Color SOFTWARE_CONTEXT_BACKGROUND_COLOR = new Color(Display.getCurrent(), new RGB(204, 255, 51));
	public static final Color DATA_TRACE_BACKGROUND_COLOR = new Color(Display.getCurrent(), new RGB(223, 128, 255));

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.nebula.widgets.nattable.config.IConfiguration#configureRegistry(org.eclipse.nebula.widgets.nattable.config.IConfigRegistry)
	 */
	@Override
	public void configureRegistry(IConfigRegistry configRegistry) {
		
        Style cellStyleError = new Style();
        cellStyleError.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, ERROR_BACKGROUND_COLOR);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, cellStyleError, DisplayMode.NORMAL, TraceViewerLabelAccumulator.ERROR_LABEL);
        
        Style cellStyleBranch = new Style();
        cellStyleBranch.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, BRANCH_BACKGROUND_COLOR);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, cellStyleBranch, DisplayMode.NORMAL, TraceViewerLabelAccumulator.BRANCH_LABEL);
        
        Style cellStyleInfo = new Style();
        cellStyleInfo.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, INFO_BACKGROUND_COLOR);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, cellStyleInfo, DisplayMode.NORMAL, TraceViewerLabelAccumulator.INFO_LABEL);
        
        Style cellStyleCustom = new Style();
        cellStyleCustom.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, CUSTOM_BACKGROUND_COLOR);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, cellStyleCustom, DisplayMode.NORMAL, TraceViewerLabelAccumulator.CUSTOM_LABEL);
        
        Style cellStyleSoftwareContext = new Style();
        cellStyleSoftwareContext.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, SOFTWARE_CONTEXT_BACKGROUND_COLOR);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, cellStyleSoftwareContext, DisplayMode.NORMAL, TraceViewerLabelAccumulator.SOFTWARE_CONTEXT_LABEL);
        
        Style cellStyleDataTrace = new Style();
        cellStyleDataTrace.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, DATA_TRACE_BACKGROUND_COLOR);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, cellStyleDataTrace, DisplayMode.NORMAL, TraceViewerLabelAccumulator.DATA_TRACE_LABEL);
        
        Style cellStyleChild = new Style();
        cellStyleChild.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, HorizontalAlignmentEnum.LEFT);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, cellStyleChild, DisplayMode.NORMAL, TraceViewerLabelAccumulator.CHILD_LABEL);

	}

}
