/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/

package com.freescale.sa.ls.traceviewer.editors;

import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;

/**
 * Class that defines the labels used for cell customization
 * @author R70188
 */
public class TraceViewerLabelAccumulator implements IConfigLabelAccumulator {
	
	public static final String ERROR_LABEL = "ERROR"; //$NON-NLS-1$
	public static final String BRANCH_LABEL = "BRANCH"; //$NON-NLS-1$
	public static final String INFO_LABEL = "INFO"; //$NON-NLS-1$
	public static final String CUSTOM_LABEL = "CUSTOM"; //$NON-NLS-1$
	public static final String CHILD_LABEL = "CHILD"; //$NON-NLS-1$
	public static final String SOFTWARE_CONTEXT_LABEL = "SOFTWARE_CONTEXT_LABEL"; //$NON-NLS-1$
	public static final String DATA_TRACE_LABEL = "DATA_TRACE_LABEL"; //$NON-NLS-1$
	
	private ILayer m_bodyLayer;
	public TraceViewerLabelAccumulator(ILayer bodyLayer){
		m_bodyLayer = bodyLayer;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator#accumulateConfigLabels(org.eclipse.nebula.widgets.nattable.layer.LabelStack, int, int)
	 */
	@Override
	public void accumulateConfigLabels(LabelStack configLabels,
			int columnPosition, int rowPosition) {
        Object data =  m_bodyLayer.getDataValueByPosition(columnPosition, rowPosition);
		if (data != null && data instanceof String) {
			String strData = (String)data;
			if (strData.equalsIgnoreCase("error")) { //$NON-NLS-1$
				configLabels.addLabel(ERROR_LABEL);
			} else if (strData.equalsIgnoreCase("branch")) { //$NON-NLS-1$
				configLabels.addLabel(BRANCH_LABEL);
			} else if (strData.equalsIgnoreCase("info")) { //$NON-NLS-1$
				configLabels.addLabel(INFO_LABEL);
			} else if (strData.equalsIgnoreCase("custom")) { //$NON-NLS-1$
				configLabels.addLabel(CUSTOM_LABEL);
			} else if (strData.equalsIgnoreCase("software context")) { //$NON-NLS-1$
				configLabels.addLabel(SOFTWARE_CONTEXT_LABEL);
			} else if (strData.equalsIgnoreCase("data trace")) { //$NON-NLS-1$
				configLabels.addLabel(DATA_TRACE_LABEL);
			} else if (!strData.equals("")) {
				// See if it is a child cell
				Object firstColumnData = m_bodyLayer.getDataValueByPosition(0, rowPosition);
				if (firstColumnData != null && firstColumnData instanceof String) {
					String firstCellString = (String)firstColumnData;
					if (firstCellString.equals("")) {
						configLabels.addLabel(CHILD_LABEL);
					}
				}
				
			}
		}		
	}

}
