/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/

package com.freescale.sa.ls.traceviewer.editors;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.event.VisualRefreshEvent;

import com.freescale.sa.util.CommonConstants;

/**
 * Class that overrides the NatTable Data Layer
 * @author R70188
 *
 */
public class TraceViewerDataLayer extends DataLayer {
	private TraceContentDataProvider m_dataProvider;
	
	public TraceViewerDataLayer(TraceContentDataProvider dataProvider) {
		super(dataProvider);
		m_dataProvider = dataProvider;
	}
	
	/*
	 * (non-Javadoc)
	 * Avoid returning null data because it affects the Find functionality
	 * when a cell with null data is selected.
	 * We need to return an empty string instead.
	 * @see org.eclipse.nebula.widgets.nattable.layer.DataLayer#getDataValue(int, int)
	 */
	@Override
	public Object getDataValue(int columnIndex, int rowIndex) {
		Object ret = super.getDataValue(columnIndex, rowIndex);
		if (ret == null) {
			ret = CommonConstants.EMPTY_STRING;
		}
		return ret;
	}
	/*
	 * (non-Javadoc)
	 * @see org.eclipse.nebula.widgets.nattable.layer.DataLayer#doCommand(org.eclipse.nebula.widgets.nattable.command.ILayerCommand)
	 */
    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof HexadecimalDisplayCommand && command.convertToTargetLayer(this)) {
        	HexadecimalDisplayCommand com = (HexadecimalDisplayCommand)command;
        	m_dataProvider.setColumnHexDisplay(com.getColumnPosition(), com.getHexDisplay());
        	this.fireLayerEvent(new VisualRefreshEvent(this));
        	return true;
        }
        else if (command instanceof DeltaDisplayCommand && command.convertToTargetLayer(this)) {
        	DeltaDisplayCommand com = (DeltaDisplayCommand)command;
        	m_dataProvider.setColumnDeltaDisplay(com.getColumnPosition(), com.getDeltaDisplay());
        	this.fireLayerEvent(new VisualRefreshEvent(this));
        	return true;
        }
        else {
        	return super.doCommand(command);
        }
    }

}
