/*******************************************************************************
 * Copyright (c) 2011-2016 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.ls.traceviewer.editors;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.tree.TreeRowModel;

/**
 * Class that creates the tree row model for the TreeLayer
 * @author R70188
 *
 */
public class TraceTreeRowModel extends TreeRowModel<Object> {

	public TraceTreeRowModel(IDataProvider dataProvider) {
		super(null);
		m_dataProvider = dataProvider;
	}
	
	@Override
	public int depth(int index) {
		String firstColumn = (String) m_dataProvider.getDataValue(0, index);
		if (firstColumn != null && !firstColumn.equals("")) //$NON-NLS-1$
			return 0;
		else
			return 1;
	}

	@Override
	public boolean isLeaf(int index) {
		String firstColumn = (String) m_dataProvider.getDataValue(0, index);
		if (firstColumn == null || firstColumn.equals("")) //$NON-NLS-1$
			return true;
		else {
			// it may have children - test the first next column
			String nextFirstColumn = (String) m_dataProvider.getDataValue(0, index + 1);
			
			// avoid reaching past the end
			if (index + 1 >= m_dataProvider.getRowCount())
				return true;
			
			if (nextFirstColumn != null && !nextFirstColumn.equals("")) //$NON-NLS-1$
				return true;
			else
				return false;
			
		}
			
	}

	@Override
	public String getObjectAtIndexAndDepth(int index, int depth) {
		return null;
	}

	@Override
	public boolean hasChildren(int index) {
		return !isLeaf(index);
	}

	@Override
	public List<Integer> getChildIndexes(int parentIndex) {
		List<Integer> result = new ArrayList<Integer>();
		String firstColumn = (String) m_dataProvider.getDataValue(0, parentIndex);
		if (firstColumn != null && !firstColumn.equals("")) { //$NON-NLS-1$
			// index exists, it is a parent node
			// check the number of following children
			int childIndex = parentIndex + 1;
			String firstChildColumn = (String) m_dataProvider.getDataValue(0, childIndex);
			while(firstChildColumn != null && firstChildColumn.equals("")) //$NON-NLS-1$
			{
				result.add(childIndex);
				childIndex ++;
				firstChildColumn = (String) m_dataProvider.getDataValue(0, childIndex);
			}
			
		}		
		return result;
	}
	
	/**
	 * This function identifies the parent of a child index.
	 * @param childIndex The value of the child index.
	 * @return Parent index value.
	 */
	public Integer getParentIndex(int childIndex) {
	    if (m_dataProvider == null) {
	        return -1;
	    }

	    if (m_dataProvider.getDataValue(0, childIndex) instanceof String) {
            String firstColumn = m_dataProvider.getDataValue(0, childIndex).toString();
            if (firstColumn != null && firstColumn.isEmpty()) {
                int parentIndex = childIndex - 1;
                Object firstParent = m_dataProvider.getDataValue(0, parentIndex);
                if (firstParent instanceof String) {
                    String firstParentColumn = firstParent.toString();

                    while (firstParentColumn != null) {
                        if (!firstParentColumn.isEmpty()) {
                            return parentIndex;
                        }
                        parentIndex --;
                        if (firstParent instanceof String) {
                            firstParentColumn = m_dataProvider.getDataValue(0, parentIndex).toString();
                        }
                    }
                }
            }
	    }

        return childIndex;
    }

	private IDataProvider m_dataProvider;

}
