/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/

package com.freescale.sa.ls.traceviewer.editors;

import org.eclipse.nebula.widgets.nattable.command.AbstractColumnCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

/**
 * Class that manages Commands that changes the display method between hexadecimal and decimal
 * @author R70188
 *
 */
public class HexadecimalDisplayCommand extends AbstractColumnCommand {

	private boolean m_hexDisplay;
	
	protected HexadecimalDisplayCommand(HexadecimalDisplayCommand command) {
		super(command);
		m_hexDisplay = command.m_hexDisplay;
	}
	
	public HexadecimalDisplayCommand(ILayer layer, int column, boolean hexDisplay) {
		super(layer,column);
		m_hexDisplay = hexDisplay;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.nebula.widgets.nattable.command.ILayerCommand#cloneCommand()
	 */
	@Override
	public ILayerCommand cloneCommand() {
		return new HexadecimalDisplayCommand(this);
	}
	
	/**
	 * Getter for hexadecimal display settings
	 * @return
	 */
	public boolean getHexDisplay() {
		return m_hexDisplay;
	}
	
}
