/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/

package com.freescale.sa.ls.traceviewer.editors;

import org.eclipse.nebula.widgets.nattable.command.AbstractColumnCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

/**
 * Class that implements delta display enable/disable functionality
 * @author R70188
 *
 */
public class DeltaDisplayCommand extends AbstractColumnCommand {

	private boolean m_deltaDisplay;
	
	protected DeltaDisplayCommand(DeltaDisplayCommand command) {
		super(command);
		m_deltaDisplay = command.m_deltaDisplay;
	}
	
	public DeltaDisplayCommand(ILayer layer, int column, boolean hexDisplay) {
		super(layer,column);
		m_deltaDisplay = hexDisplay;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.nebula.widgets.nattable.command.ILayerCommand#cloneCommand()
	 */
	@Override
	public ILayerCommand cloneCommand() {
		return new DeltaDisplayCommand(this);
	}
	
	/**
	 * Getter for delta display settings
	 * @return
	 */
	public boolean getDeltaDisplay() {
		return m_deltaDisplay;
	}

}
