/*******************************************************************************
 * Copyright (c) 2011-2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/

package com.freescale.sa.ls.traceviewer.editors;


import java.util.Map;

import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;


/**
 * This class extends the <code>DefaultColumnHeaderDataProvider</code> in order
 * to allow the user to change the columns names.
 * 
 */
public class CustomizableColumnHeaderDataProvider extends DefaultColumnHeaderDataProvider {

	private String[] m_propertyNames;

	private Map<String, String> m_propertyToLabelMap;

	/**
	 * @param columnLabels Labels including type identifier in paranthesis
	 *            The column labels.
	 */
	public CustomizableColumnHeaderDataProvider(String[] columnLabels) {
		super(columnLabels);
		m_propertyNames = columnLabels.clone(); 
	}

	/**
	 * @param propertyNames
	 *            The column Labels.
	 * @param propertyToLabelMap
	 *            A map that keeps the correspondence between the column labels
	 *            and the text that should be displayed for each column.
	 */
	public CustomizableColumnHeaderDataProvider(String[] propertyNames,
			Map<String, String> propertyToLabelMap) {
		super(propertyNames, propertyToLabelMap);
		m_propertyNames = propertyNames.clone();
		m_propertyToLabelMap = propertyToLabelMap;
	}

	@Override
	public String getColumnHeaderLabel(int columnIndex) {
		String propertyName = m_propertyNames[columnIndex];
		if (m_propertyToLabelMap != null) {
			String label = m_propertyToLabelMap.get(propertyName);
			if (label != null) {
				return label;
			}
		}
		return propertyName;
	}

	@Override
	public int getColumnCount() {
		return m_propertyNames.length;
	}

	/**
	 * Set column labels.
	 * 
	 * @param columnLabels
	 */
	public void setColumnLabels(String[] columnLabels) {
		m_propertyNames = columnLabels.clone();
	}

	/**
	 * Update the column names.
	 * 
	 * @param propertyNames
	 *            Column labels.
	 * @param propertyToLabelMap
	 *            A map that keeps the correspondence between the column labels
	 *            and the text that should be displayed for each column.
	 */
	public void updateHeader(String[] propertyNames,
			Map<String, String> propertyToLabelMap) {
		m_propertyNames = propertyNames.clone();
		m_propertyToLabelMap = propertyToLabelMap;
	}

}
