/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.ui.hierarchicalprofiler.editors;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;

import com.freescale.sa.model.IAnalyzer;
import com.freescale.sa.ui.common.SAErrorDialog;
import com.freescale.sa.ui.common.SAUILSPlugin;
import com.freescale.sa.ui.common.UIMessages;
import com.freescale.sa.ui.common.editor.flatprofiler.FlatProfilerFileInput;
import com.freescale.sa.ui.common.editor.flatprofiler.FlatProfilerInput;
import com.freescale.sa.ui.common.editor.flatprofiler.FlatProfilerTab;

public class HierarchicalProfilerInput extends FlatProfilerInput {

	public HierarchicalProfilerInput(String projectName, String fileName) {
		super(projectName, fileName);
	}

	public HierarchicalProfilerInput(String fileName) {
		super(fileName);
	}

	@Override
	public String getDisplayId() {
		return "Hierarchical Profiler"; //$NON-NLS-1$
	}

	@Override
	protected void showError() {
		/*
		 * Show error only for critical code and performance. File coverage is
		 * included in critical code, no reason to show the error twice.
		 */
		SAErrorDialog.showErrorDialog(
				UIMessages.FlatProfilerInput_not_supported,
				UIMessages.FlatProfilerInput_no_function_info, new Status(
						IStatus.ERROR, SAUILSPlugin.PLUGIN_ID,
						UIMessages.FlatProfilerInput_no_disassembly));
	}

	protected FlatProfilerTab createTab(FlatProfilerFileInput fileInput,
			String section, Composite folder, IAnalyzer analyzer) {
		return new HierarchicalProfilerTab(fileInput, section, folder, analyzer);
	}
}
