/*******************************************************************************
 * Copyright (c) 2011, 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.ui.hierarchicalprofiler.editors;


import java.io.File;

import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

import com.freescale.sa.ui.common.UIMessages;
import com.freescale.sa.ui.common.editor.AbstractTraceEditorInput;
import com.freescale.sa.ui.common.editor.flatprofiler.FlatProfilerInput;
import com.freescale.sa.util.CommonConstants;
import com.ibm.icu.text.MessageFormat;


public class HierarchicalEditorInput extends AbstractTraceEditorInput {

	protected final String m_baseFileName;
	protected final FlatProfilerInput m_input;
	
	private static Logger LOGGER = Logger.getLogger(HierarchicalEditorInput.class);

	public HierarchicalEditorInput(FlatProfilerInput input, String name, String storageDirectory) {
		super(storageDirectory);
		m_input = input;
		m_baseFileName = name;
	}

	public FlatProfilerInput getDataInput() {
		return m_input;
	}

	@Override
	public boolean exists() {
		return m_input != null;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return null;
	}

	@Override
	public String getName() {
		try {
			File fi = new File(m_baseFileName);
			String name = fi.getName();
			return name;
		} catch (Exception ex) {
			LOGGER.error(ex);
		}
		
		return CommonConstants.EMPTY_STRING;
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IEditorInput#getToolTipText()
	 */
	@Override
	public String getToolTipText() {
		return MessageFormat.format(UIMessages.Editor_Input_Tooltip_Performance, new Object[] { m_baseFileName });
	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	@SuppressWarnings("rawtypes")
	@Override
	public Object getAdapter(Class adapter) {
		if (HierarchicalEditorInput.class.equals(adapter)) {
			return this;
		}
		return null;
	}
	
	/**
	 * @return The name of the input file.
	 */
	public String getInputFileName() {
		return m_input.fileInput.m_fileName;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final HierarchicalEditorInput other = (HierarchicalEditorInput)obj;

		// If the input is not null, differentiate based on the input file.
		if (m_input != null) {
			return getInputFileName().equals(other.getInputFileName());
		}
		LOGGER.debug("[equals]: The input file is null. Trying to differentiate based on the name of the editor."); //$NON-NLS-1$

		// Otherwise, if the name is not null, differentiate based on the name.
		if (m_baseFileName != null) {
			return m_baseFileName.equals(other.m_baseFileName);
		}
		LOGGER.debug("[equals]: null editor input name."); //$NON-NLS-1$
		// Otherwise, differentiate based on whether the other is also null.
		return (other.m_baseFileName == null);
	}
	
	public int hashCode() {
		return super.hashCode();
	}

}
