/*******************************************************************************
 * Copyright (c) 2011, 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.ui.hierarchicalprofiler.editors;

import java.io.File;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;

import com.freescale.sa.ui.common.AbstractSaEditor;
import com.freescale.sa.ui.common.SAUILSPlugin;
import com.freescale.sa.ui.common.editor.flatprofiler.FlatProfilerInput;
import com.freescale.sa.ui.common.flatdata.UIResourceBundle;
import com.freescale.sa.ui.hierarchical.utils.UIConstants;

public class HierarchicalEditor extends AbstractSaEditor {

	protected FlatProfilerInput m_dataInput;

	/**
	 * The unique ID of this editor.
	 */
	public static final String ID = "com.freescale.sa.ui.hierarchicalprofiler"; //$NON-NLS-1$

	/**
	 * Creates a flat data editor.
	 */
	public HierarchicalEditor() {
		super(ID, UIConstants.Hierarchical_Context_Id);
	}

	protected HierarchicalEditor(String id, String helpContextId) {
		super(id, helpContextId);
	}

	@Override
	protected void createPartControl0(Composite parent) {
		m_dataInput.draw(parent);
	}

	/**
	 * We don't need to save anything for critical code
	 */
	public void doSave(IProgressMonitor monitor) {
	}

	/**
	 * We don't need to save anything for critical code
	 */
	public void doSaveAs() {
	}

	/**
	 * We don't need to save anything for critical code
	 */
	public boolean isSaveAsAllowed() {
		return false;
	}

	public void setFocus() {
	}

	/**
	 * We don't do any editing for critical code
	 */
	public boolean isDirty() {
		return false;
	}

	/**
	 * The <code>MultiPageEditorExample</code> implementation of this method
	 * checks that the input is an instance of <code>IFileEditorInput</code>.
	 */
	public void init(IEditorSite site, IEditorInput editorInput)
			throws PartInitException {
		if (!(editorInput instanceof HierarchicalEditorInput)
				&& !(editorInput instanceof FileStoreEditorInput)
				&& !(editorInput instanceof FileEditorInput)
				&& !(editorInput instanceof IPathEditorInput)) {
			throw new PartInitException(
					"This editor only opens Hierarchical Profiler data or files with " + UIConstants.performance_file_extension); //$NON-NLS-1$
		}

		if (editorInput instanceof FileEditorInput) {
			FileEditorInput inputFile = (FileEditorInput) editorInput;
			String fileName = inputFile.getPath().toString();
			setProject(inputFile);

			FlatProfilerInput flInput = new HierarchicalProfilerInput(fileName);
			flInput.setEditor(this);
			editorInput = new HierarchicalEditorInput(flInput, fileName, "."); //$NON-NLS-1$
			setPartName(new File(fileName).getName());
		} else if (editorInput instanceof IPathEditorInput) {
			String fileName = ((IPathEditorInput) editorInput).getPath()
					.toOSString();
			FlatProfilerInput flInput = new HierarchicalProfilerInput(fileName);
			flInput.setEditor(this);
			editorInput = new HierarchicalEditorInput(flInput, fileName, "."); //$NON-NLS-1$
			setPartName(new File(fileName).getName());
		} else if (editorInput instanceof FileStoreEditorInput) {
			FileStoreEditorInput inputFile = (FileStoreEditorInput) editorInput;
			String fileName = inputFile.getURI().getPath().toString();
			FlatProfilerInput flInput = new HierarchicalProfilerInput(fileName);
			flInput.setEditor(this);
			editorInput = new HierarchicalEditorInput(flInput, fileName, "."); //$NON-NLS-1$
			setPartName(new File(fileName).getName());
		} else {
			setPartName(editorInput.getName());
		}

		m_dataInput = ((HierarchicalEditorInput) editorInput).getDataInput();
		setInput(editorInput);
		setSite(site);
		
		if (m_dataInput.fileInput.getIsFilteredFile()) {
			setPartName(m_dataInput.fileInput.getFilterTitle());
		}
	}

	/**
	 * Refresh editor input using new trace data.
	 */
	public void refresh() {
		m_dataInput.refreshDisplay();
	}

	public String getBaseName() {
		Path fileInp = new Path(m_dataInput.getFileName());
		return fileInp.lastSegment().replaceAll(
				"." + UIConstants.performance_file_extension, ""); //$NON-NLS-1$ //$NON-NLS-2$ $NON-NLS-2$
	}

	@Override
	public String getHeaderText() {
		if (m_dataInput != null && getEditorType() != null) {

			Path dirPath = new Path(m_dataInput.getFileName());
			String sampleName = dirPath.removeFileExtension().lastSegment();
			
			if (m_dataInput.getTraceType() == null) {
				return getEditorType() + " - " + sampleName; //$NON-NLS-1$
			} else {
				return m_dataInput.getTraceType() + " " + getEditorType() + " - " + sampleName;  //$NON-NLS-1$  //$NON-NLS-2$
			}
		}

		return super.getHeaderText();
	}

	@Override
	public void dispose() {
		super.dispose();
	}

	@Override
	public String getEditorType() {
		return UIResourceBundle.ProfileResultsInput_Performance;
	}

	@Override
	public Image getHeaderImage() {
		return SAUILSPlugin.imageDescriptorFromPlugin(UIConstants.PLUGIN_ID,
				UIConstants.analysis_performance_iconfile).createImage();
	}

	@Override
	public String getStoragePath() {
		return new Path(m_dataInput.getFileName()).removeLastSegments(1)
				.toOSString();
	}
}
