/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/

package com.freescale.sa.ui.hierarchicalprofiler.chart;

/**
 * This class describes data from a pie slice
 * 
 * @author B46903
 * 
 */
public class SliceData implements Comparable<SliceData> {
	private String name;
	private Number value;
	private Object data;
	private Integer index;
	
	public SliceData(String name, Number value, Object data, Integer index) {
		this.name = name;
		this.value = value;
		this.data = data;
		this.index = index;
	}

	/**
	 * Gets the slice's name
	 * 
	 * @return The slice's name
	 */
	public String getName() {
		return name;
	}

	/**
	 * Sets the name of slice
	 * 
	 * @param name
	 *            The name of slice
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Returns the value of slice
	 * 
	 * @return The value
	 */
	public Number getValue() {
		return value;
	}

	/**
	 * Sets the slice's value
	 * 
	 * @param value
	 */
	public void setValue(Number value) {
		this.value = value;
	}

	/**
	 * Gets the private data of slice. Usually it's a ItemPosition object.
	 * 
	 * @return The private data of the slice.
	 */
	public Object getData() {
		return data;
	}

	/**
	 * Sets the private data
	 * 
	 * @param data
	 */
	public void setData(Object data) {
		this.data = data;
	}

	/**
	 * Returns a representative string for this slice
	 * 
	 * @return A representative string for current slice
	 */
	public String getLabel() {
		return name + "_" + index; //$NON-NLS-1$
	}

	/**
	 * Returns the slice's index
	 * 
	 * @return The index of the slice
	 */
	public Integer getIndex() {
		return index;
	}

	/**
	 * Set the index of the slice
	 * 
	 * @param index
	 */
	public void setIndex(Integer index) {
		this.index = index;
	}

	/**
	 * Two slices are compared by labels
	 */
	@Override
	public int compareTo(SliceData o) {
		return getLabel().compareTo(o.getLabel());
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((data == null) ? 0 : data.hashCode());
		result = prime * result + ((index == null) ? 0 : index.hashCode());
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		result = prime * result + ((value == null) ? 0 : value.hashCode());
		return result;
	}
	
	@Override
	public boolean equals(Object arg0) {
		if (arg0 == null) {
			return false;
		}
		
		if (!(arg0 instanceof SliceData)) {
			return false;
		}
		
		return (compareTo((SliceData)arg0) == 0);
	}
}
