/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/

package com.freescale.sa.ui.hierarchicalprofiler.chart;

import org.apache.log4j.Logger;

/**
 * Describes a slice from a pie chart.
 * 
 * @author B46903
 * 
 */
class PieSlice {
	private static final Logger LOGGER = Logger.getLogger(PieSlice.class);

	/**
	 * The slice's id in PiePlot
	 */
	private Object sliceKey;
	/**
	 * The angular extent of the arc in degrees
	 */
	private Double extent;
	/**
	 * The starting angle of the arc in degrees
	 */
	private Double start;

	private boolean explode;
	private boolean implode;

	public PieSlice(Object sliceKey, Double extent) {
		this.extent = extent;
		explode = false;
		implode = false;
	}

	public Object getSliceKey() {
		return sliceKey;
	}

	public void setSliceKey(Integer sliceKey) {
		this.sliceKey = sliceKey;
	}

	public Double getExtent() {
		return extent;
	}

	public void setExtent(Double extent) {
		this.extent = extent;
	}

	public Double getStart() {
		return start;
	}

	public void setStart(Double start) {
		this.start = start;
	}

	public Double getEnd() {
		return (start + extent) % 360;
	}

	public Double getMiddle() {
		return start + extent / 2;
	}

	public synchronized boolean isExploding() {
		return explode;
	}

	public synchronized boolean isImploding() {
		return implode;
	}

	public synchronized void setExplode(boolean explode) {
		this.explode = explode;
		checkIntegrity();
	}
	
	private void checkIntegrity () {
		if (explode && implode) {
			LOGGER.debug("Inconsistent state"); //$NON-NLS-1$
		}
	}

	public synchronized void setImplode(boolean implode) {
		this.implode = implode;
		checkIntegrity();
	}
}
