/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/

package com.freescale.sa.ui.calltree.utils;


public interface UIConstants {
	final static String calltree_file_extension = "calltree"; //$NON-NLS-1$

	// Used by Call Tree
	public static final String flatdata_callPair_line = "Call Pair"; //$NON-NLS-1$
	public static final String flatdata_caller_name = "Caller Name"; //$NON-NLS-1$
	public static final String flatdata_callee_name = "Callee Name"; //$NON-NLS-1$
	public static final String flatdata_caller_ID = "Caller ID"; //$NON-NLS-1$
	public static final String flatdata_callee_ID = "Callee ID"; //$NON-NLS-1$
	public static final String flatdata_caller_function_ID = "Caller Function ID"; //$NON-NLS-1$
	public static final String flatdata_callee_function_ID = "Callee Function ID"; //$NON-NLS-1$
	public static final String flatdata_call_site = "Call Site"; //$NON-NLS-1$
	public static final String flatdata_no_of_calls = "Number of calls"; //$NON-NLS-1$
	public static final String flatdata_source_file_path = "Source File Path"; //$NON-NLS-1$
	public static final String flatdata_line_no = "Line Number"; //$NON-NLS-1$
	public static final String flatdata_max_call_stack = "Max Call Stack"; //$NON-NLS-1$
	public static final String flatdata_max_size_stack = "Max Size Stack"; //$NON-NLS-1$
	public static final String flatdata_total_calls_of_parent = "%% Total calls of parent"; //$NON-NLS-1$
	public static final String flatdata_total_time_it_was_called = "%% Total times it was called"; //$NON-NLS-1$
	public static final String flatdata_inclusive_time = "Inclusive Time"; //$NON-NLS-1$
	public static final String flatdata_grayed_out_symbol = "Grayed Out"; //$NON-NLS-1$

	/**
	 * Extension for archived sources.
	 */
	public final static String ZIP_EXTENSION = ".sa_sources"; //$NON-NLS-1$

	// The plug-in ID
	public static final String PLUGIN_ID = "com.freescale.sa.ui.calltree"; //$NON-NLS-1$

	// Icons
	final static String analysis_calltree_iconfile = "icons/calltree.gif"; //$NON-NLS-1$
	final static String analysis_dot_iconfile = "icons/DOT.png"; //$NON-NLS-1$
	final static String analysis_isr_iconfile = "icons/calltree_isr.gif"; //$NON-NLS-1$
	final static String analysis_function_iconfile = "icons/calltree_func.png"; //$NON-NLS-1$

	public static final String CallTree_Context_Id = PLUGIN_ID + ".calltree_contexthelp"; //$NON-NLS-1$

	/**
	 * The extension of the configuration file for decoded trace. This is
	 * currently an archived configuration.
	 */
	public final static String decoded_trace_config_extension = "config"; //$NON-NLS-1$
}
