/*******************************************************************************
 * Copyright (c) 2014, 2015 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.ui.calltree.utils;

import java.math.BigInteger;

public final class EdgeRec {
	private int callerId = (int) 0;
	public int callerFunctionId = (int) 0;
	private String callerShortName = null;
	public BigInteger callSite = BigInteger.ZERO;
	public String callSiteFile = null;
	public int callSiteLineNo = (int) 0;
	public int calleeId = (int) 0;
	public int calleeFunctionId = (int) 0;
	public String calleeShortName = null;
	public int numCalls = (int) 0;
	public String isInMaxCallStack = null;
	public String isInMaxSizeStack = null;
	public float totalCallsOfParent = (float) 0;
	public float totalTimeItWasCalled = (float) 0;
	public double inclusiveTime = (double) 0;
	private boolean grayedOut = false;
	
	public static final Integer INVALID_FUNCTION_ID = 0;

	public EdgeRec() {
	}

	public EdgeRec(Integer _callerId, Integer _callerFunctionId, String _callerName, BigInteger _callSite, String _callSiteFile,
			Integer _callSiteLineNo, Integer _calleeId, Integer _calleeFunctionId, String _calleeName, Integer _numCalls,
			String _isInMaxCallStack, String _isInMaxSizeStack, Float _totalCallsOfParent, Float _totalTimeItWasCalled,
			Double _inclusiveTime, Boolean _grayedOut) {
		setCallerId(_callerId);
		callerFunctionId = _callerFunctionId;
		setCallerShortName(_callerName);
		calleeId = _calleeId;
		calleeFunctionId = _calleeFunctionId;
		calleeShortName = _calleeName;
		callSite = _callSite;
		callSiteFile = _callSiteFile;
		callSiteLineNo = _callSiteLineNo;
		numCalls = _numCalls;
		isInMaxCallStack = _isInMaxCallStack;
		isInMaxSizeStack = _isInMaxSizeStack;
		totalCallsOfParent = _totalCallsOfParent;
		totalTimeItWasCalled = _totalTimeItWasCalled;
		inclusiveTime = _inclusiveTime;
		setGrayedOut(_grayedOut);
	} // ctor

	public String getCallerShortName() {
		return callerShortName;
	}

	public void setCallerShortName(String callerShortName) {
		this.callerShortName = callerShortName;
	}

	public int getCallerId() {
		return callerId;
	}
	
	public int getCallerFunctionId() {
		return callerFunctionId;
	}
	
	public int getCalleeFunctionId() {
		return calleeFunctionId;
	}

	public void setCallerId(int callerId) {
		this.callerId = callerId;
	}

	public boolean isGrayedOut() {
		return grayedOut;
	}

	public void setGrayedOut(boolean grayedOut) {
		this.grayedOut = grayedOut;
	}

	public boolean isInMaxSizeStack() {
		if (isInMaxSizeStack == null) {
			return false;
		}

		return Boolean.parseBoolean(isInMaxSizeStack);
	}

	public boolean isInMaxCallStack() {
		if (isInMaxCallStack == null) {
			return false;
		}

		return Boolean.parseBoolean(isInMaxCallStack);
	}

} // class EdgeRec

