/*******************************************************************************
 * Copyright (c) 2011, 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.ui.calltree.editor;

import java.io.File;
import java.text.MessageFormat;

import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

import com.freescale.sa.ui.calltree.utils.UIMessages;
import com.freescale.sa.ui.common.AbstractTraceEditorInput;
import com.freescale.sa.util.CommonConstants;

public class CallTreeEditorInput extends AbstractTraceEditorInput {

	private final String m_baseFileName;
	private final CallTreeInput m_input;
	private static Logger LOGGER = Logger.getLogger(CallTreeEditorInput.class);

	public CallTreeEditorInput(CallTreeInput input, String baseName, String storageDirectory) {
		super(storageDirectory);
		m_input = input;
		m_baseFileName = baseName;
	}

	public CallTreeInput getDataInput() {
		return m_input;
	}

	@Override
	public boolean exists() {
		return m_input != null;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return null;
	}

	@Override
	public String getName() {
		try {
			File fi = new File(m_baseFileName);
			String name = fi.getName();
			return name;
		} catch (Exception ex) {
			LOGGER.error(ex);
		}
		
		return CommonConstants.EMPTY_STRING;
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IEditorInput#getToolTipText()
	 */
	@Override
	public String getToolTipText() {
		return MessageFormat.format(UIMessages.Editor_Input_Tooltip_CallTree, new Object[] { m_baseFileName });
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	@SuppressWarnings("rawtypes")
	@Override
	public Object getAdapter(Class adapter) {
		if (CallTreeEditorInput.class.equals(adapter)) {
			return this;
		}
		return null;
	}

	@Override
	public boolean equals(Object obj) {

		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final CallTreeEditorInput other = (CallTreeEditorInput) obj;

		// If the input is not null, differentiate based on the input file.
		if (m_input != null) {
			return getDataInput().getFilePath().equals(other.getDataInput().getFilePath());
		}

		// Otherwise, if the name is not null, differentiate based on the name.
		if (m_baseFileName != null) {
			return m_baseFileName.equals(other.m_baseFileName);
		}

		// Otherwise, differentiate based on whether the other is also null.
		return (other.m_baseFileName == null);
	}

	public int hashCode() {
		return super.hashCode();
	}

	public void refresh() {
		m_input.refresh(true);
	}

}
