/*******************************************************************************
 * Copyright (c) 2011, 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/
package com.freescale.sa.ui.calltree.editor;

import java.io.File;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;

import com.freescale.sa.ui.calltree.utils.UIConstants;
import com.freescale.sa.ui.calltree.utils.UIMessages;
import com.freescale.sa.ui.common.AbstractSaEditor;
import com.freescale.sa.ui.common.SAUILSPlugin;
import com.freescale.sa.ui.common.flatdata.UIResourceBundle;
import com.freescale.sa.util.CommonConstants;

public class CallTreeEditor extends AbstractSaEditor {

	private CallTreeInput m_dataInput = null;

	/**
	 * Creates a flat data editor.
	 */
	public CallTreeEditor() {
		super(UIConstants.PLUGIN_ID, UIConstants.CallTree_Context_Id);
	}

	@Override
	protected void createPartControl0(Composite parent) {
		m_dataInput.draw(parent);
	}

	/**
	 * We don't need to save anything for critical code
	 */
	public void doSave(IProgressMonitor monitor) {
	}

	/**
	 * We don't need to save anything for critical code
	 */
	public void doSaveAs() {
	}

	/**
	 * We don't need to save anything for critical code
	 */
	public boolean isSaveAsAllowed() {
		return false;
	}

	public void setFocus() {
	}

	/**
	 * We don't do any editing for critical code
	 */
	public boolean isDirty() {
		return false;
	}

	/**
	 * The <code>MultiPageEditorExample</code> implementation of this method
	 * checks that the input is an instance of <code>IFileEditorInput</code>.
	 */
	public void init(IEditorSite site, IEditorInput editorInput)
			throws PartInitException {
		if (!(editorInput instanceof CallTreeEditorInput)
				&& !(editorInput instanceof FileStoreEditorInput)
				&& !(editorInput instanceof FileEditorInput)
				&& !(editorInput instanceof IPathEditorInput)) {
			throw new PartInitException(UIMessages.Editor_CallTree_Error);
		}

		if (editorInput instanceof FileEditorInput) {
			FileEditorInput inputFile = (FileEditorInput) editorInput;
			String fileName = inputFile.getPath().toString();
			CallTreeInput ctInput = new CallTreeInput(fileName);
			ctInput.setEditor(this);
			editorInput = new CallTreeEditorInput(ctInput,
					fileName, "."); //$NON-NLS-1$
			setPartName(new File(fileName).getName());
			setProject(inputFile);
		} else if (editorInput instanceof IPathEditorInput) {
			String fileName = ((IPathEditorInput) editorInput).getPath()
					.toOSString();
			CallTreeInput ctInput = new CallTreeInput(fileName);
			ctInput.setEditor(this);
			editorInput = new CallTreeEditorInput(ctInput,
					fileName, "."); //$NON-NLS-1$
			setPartName(new File(fileName).getName());
		} else if (editorInput instanceof FileStoreEditorInput) {
			FileStoreEditorInput inputFile = (FileStoreEditorInput) editorInput;
			String fileName = inputFile.getURI().getPath().toString();
			CallTreeInput ctInput = new CallTreeInput(fileName);
			ctInput.setEditor(this);
			editorInput = new CallTreeEditorInput(ctInput,
					fileName, "."); //$NON-NLS-1$
			setPartName(new File(fileName).getName());
		} else {
			setPartName(editorInput.getName());
		}

		m_dataInput = ((CallTreeEditorInput) editorInput).getDataInput();
		setInput(editorInput);
		setSite(site);
		
		if (m_dataInput.getFlatProfiler().getIsFilteredFile()) {
			setPartName(m_dataInput.getFlatProfiler().getFilterTitle());
		}
	}

	/**
	 * Refresh editor input using new trace data.
	 */
	public void refresh() {
		m_dataInput.refresh(true);
	}

	public String getBaseName() {
		Path fileInp = new Path(m_dataInput.getFlatProfiler().m_fileName);
		String launchConfigName = fileInp.lastSegment().replaceAll(
				"." + UIConstants.calltree_file_extension, CommonConstants.EMPTY_STRING); //$NON-NLS-1$
		return launchConfigName;
	}

	@Override
	public String getHeaderText() {
		if (m_dataInput != null && getEditorType() != null) {

			Path dirPath = new Path(m_dataInput.getFilePath());
			String sampleName = dirPath.removeFileExtension().lastSegment();
		
			if (m_dataInput.getTraceType() == null) {
				return getEditorType() + " - " + sampleName; //$NON-NLS-1$
			} else {
				return m_dataInput.getTraceType() + " " + getEditorType() + " - " + sampleName;  //$NON-NLS-1$  //$NON-NLS-2$
			}
		}

		return super.getHeaderText();
	}

	@Override
	public String getEditorType() {
		return UIResourceBundle.ProfileResultsInput_CallTree;
	}

	@Override
	public Image getHeaderImage() {
		return SAUILSPlugin.imageDescriptorFromPlugin(UIConstants.PLUGIN_ID,
				UIConstants.analysis_calltree_iconfile).createImage();
	}

	@Override
	public String getStoragePath() {
		return new Path(m_dataInput.getFilePath()).removeLastSegments(1)
				.toOSString();
	}

}
