/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc. All rights reserved.
 * Freescale Internal Only. Not for distribution
 *******************************************************************************/

package com.freescale.sa.ui.calltree.editor;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import com.freescale.sa.ui.calltree.utils.CallTreeContext;
import com.freescale.sa.ui.common.IHierarchicalItem;

class CallTreeContentProvider implements ITreeContentProvider {

	/**
	 * Returns an array with the children for arg0 or null.
	 * 
	 * @param arg0
	 *            The parent for children.
	 */
	@SuppressWarnings("unchecked")
	public Object[] getChildren(Object arg0) {
		if (arg0 instanceof ArrayList<?>) {
			return ((ArrayList<?>) arg0).toArray();
		}

		if (!(arg0 instanceof IHierarchicalItem)) {
			return null;
		}

		Collection<IHierarchicalItem> items = (Collection<IHierarchicalItem>) ((IHierarchicalItem) arg0).getChildren();

		if (items == null) {
			return null;
		}

		return items.toArray();
	}

	/**
	 * Returns an array with the children for arg0 or null.
	 * 
	 * @param arg0
	 *            The parent for children.
	 * @param callTree
	 *            CallTreeInput useful for non UI runs. It should not be null
	 *            when UI is used.
	 */
	public Object[] getChildrenFromTree(Object arg0, CallTreeContext context) {
		return null;
	}

	public Object getParent(Object arg0) {
		if (!(arg0 instanceof IHierarchicalItem)) {
			return null;
		}

		return ((IHierarchicalItem) arg0).getParent();
	}

	public boolean hasChildren(Object arg0) {
		if (!(arg0 instanceof IHierarchicalItem)) {
			return false;
		}

		return ((IHierarchicalItem) arg0).hasChildren();
	}

	/* Table Functions */
	public Object[] getElements(Object arg0) {
		return getChildren(arg0);
	}

	/**
	 * Disposes any resources
	 */
	public void dispose() {
		// We don't create any resources, so we don't dispose any
	}

	/**
	 * Called when the input changes
	 * 
	 * @param arg0
	 *            the parent viewer
	 * @param arg1
	 *            the old input
	 * @param arg2
	 *            the new input
	 */
	public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
		// Nothing to do
	}
}
